/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.cloud.gateway.exchange;

import io.vertx.core.Future;
import io.vertx.core.MultiMap;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.Cookie;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.net.SocketAddress;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.noear.solon.cloud.gateway.exchange.ExNewRequest;
import org.noear.solon.cloud.gateway.exchange.ExNewResponse;
import org.noear.solon.cloud.gateway.properties.TimeoutProperties;
import org.noear.solon.cloud.gateway.route.Route;

public class ExContext {
    private final Map<String, Object> attrMap;
    private final HttpServerRequest rawRequest;
    private ExNewRequest newRequest;
    private ExNewResponse newResponse;
    private URI target;
    private TimeoutProperties timeout;
    private URI rawURI;

    public ExContext(HttpServerRequest rawRequest) {
        this.rawRequest = rawRequest;
        this.attrMap = new HashMap<String, Object>();
    }

    public <T> T attr(String key) {
        return (T)this.attrMap.get(key);
    }

    public void attrSet(String key, Object value) {
        this.attrMap.put(key, value);
    }

    public void bind(Route route) {
        if (route != null) {
            this.target = route.getTarget();
            this.timeout = route.getTimeout();
        }
    }

    public URI target() {
        return this.target;
    }

    public TimeoutProperties timeout() {
        return this.timeout;
    }

    public SocketAddress remoteAddress() {
        return this.rawRequest.remoteAddress();
    }

    public SocketAddress localAddress() {
        return this.rawRequest.localAddress();
    }

    public boolean isSecure() {
        return this.rawRequest.isSSL();
    }

    public String rawMethod() {
        return this.rawRequest.method().name();
    }

    public URI rawURI() {
        if (this.rawURI == null) {
            this.rawURI = URI.create(this.rawRequest.absoluteURI());
        }
        return this.rawURI;
    }

    public String rawPath() {
        return this.rawRequest.path();
    }

    public String rawQueryString() {
        return this.rawRequest.query();
    }

    public String rawQueryParam(String key) {
        return this.rawRequest.getParam(key);
    }

    public MultiMap rawQueryParamsAll() {
        return this.rawRequest.params();
    }

    public String rawHeader(String key) {
        return this.rawRequest.getHeader(key);
    }

    public MultiMap rawHeadersAll() {
        return this.rawRequest.headers();
    }

    public String rawCookie(String key) {
        Cookie cookie = this.rawRequest.getCookie(key);
        if (cookie == null) {
            return null;
        }
        return cookie.getValue();
    }

    public Set<Cookie> rawCookiesAll() {
        return this.rawRequest.cookies();
    }

    public ExNewRequest newRequest() {
        if (this.newRequest == null) {
            this.newRequest = new ExNewRequest();
            this.newRequest.method(this.rawRequest.method().name());
            this.newRequest.queryString(this.rawRequest.query());
            this.newRequest.path(this.rawRequest.path());
            for (Map.Entry kv : this.rawRequest.headers().entries()) {
                this.newRequest.headerAdd((String)kv.getKey(), (String)kv.getValue());
            }
            this.newRequest.body((Future<Buffer>)this.rawRequest.body());
        }
        return this.newRequest;
    }

    public ExNewResponse newResponse() {
        if (this.newResponse == null) {
            this.newResponse = new ExNewResponse();
        }
        return this.newResponse;
    }
}

