/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.cache.jedis;

import java.util.Properties;
import org.noear.redisx.RedisClient;
import org.noear.solon.Solon;
import org.noear.solon.Utils;
import org.noear.solon.data.cache.CacheService;
import org.noear.solon.data.cache.Serializer;
import org.noear.solon.data.cache.impl.JavabinSerializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RedisCacheService
implements CacheService {
    static final Logger log = LoggerFactory.getLogger(RedisCacheService.class);
    protected String _cacheKeyHead;
    protected int _defaultSeconds;
    protected Serializer<String> _serializer = null;
    protected boolean _enableMd5key = true;
    protected final RedisClient client;

    public RedisCacheService enableMd5key(boolean enable) {
        this._enableMd5key = enable;
        return this;
    }

    public RedisCacheService serializer(Serializer<String> serializer) {
        if (serializer != null) {
            this._serializer = serializer;
        }
        return this;
    }

    public RedisCacheService(RedisClient client, int defSeconds) {
        this(client, null, defSeconds);
    }

    public RedisCacheService(RedisClient client, String keyHeader, int defSeconds) {
        this.client = client;
        if (Utils.isEmpty((String)keyHeader)) {
            keyHeader = Solon.cfg().appName();
        }
        if (defSeconds < 1) {
            defSeconds = 30;
        }
        this._cacheKeyHead = keyHeader;
        this._defaultSeconds = defSeconds;
        this._serializer = JavabinSerializer.instance;
    }

    public RedisCacheService(Properties prop) {
        this(prop, prop.getProperty("keyHeader"), 0);
    }

    public RedisCacheService(Properties prop, String keyHeader, int defSeconds) {
        String defSeconds_str = prop.getProperty("defSeconds");
        String db_str = prop.getProperty("db");
        String maxTotal_str = prop.getProperty("maxTotal");
        if (defSeconds == 0 && Utils.isNotEmpty((String)defSeconds_str)) {
            defSeconds = Integer.parseInt(defSeconds_str);
        }
        int db = 0;
        int maxTotal = 200;
        if (Utils.isNotEmpty((String)db_str)) {
            db = Integer.parseInt(db_str);
        }
        if (Utils.isNotEmpty((String)maxTotal_str)) {
            maxTotal = Integer.parseInt(maxTotal_str);
        }
        if (Utils.isEmpty((String)keyHeader)) {
            keyHeader = Solon.cfg().appName();
        }
        if (defSeconds < 1) {
            defSeconds = 30;
        }
        this._cacheKeyHead = keyHeader;
        this._defaultSeconds = defSeconds;
        this._serializer = JavabinSerializer.instance;
        this.client = new RedisClient(prop, db, maxTotal);
    }

    public RedisClient client() {
        return this.client;
    }

    public void store(String key, Object obj, int seconds) {
        if (obj == null) {
            return;
        }
        String newKey = this.newKey(key);
        try {
            String val = (String)this._serializer.serialize(obj);
            if (seconds > 0) {
                this.client.open(ru -> ru.key(newKey).expire(seconds).set(val));
            } else {
                this.client.open(ru -> ru.key(newKey).expire(this._defaultSeconds).set(val));
            }
        }
        catch (Exception e) {
            log.warn(e.getMessage(), (Throwable)e);
        }
    }

    public <T> T get(String key, Class<T> clz) {
        String newKey = this.newKey(key);
        String val = (String)this.client.openAndGet(ru -> ru.key(newKey).get());
        if (val == null) {
            return null;
        }
        try {
            return (T)this._serializer.deserialize((Object)val, clz);
        }
        catch (Exception e) {
            log.warn(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public void remove(String key) {
        String newKey = this.newKey(key);
        this.client.open(ru -> ru.key(newKey).delete());
    }

    protected String newKey(String key) {
        if (this._enableMd5key) {
            return this._cacheKeyHead + ":" + Utils.md5((String)key);
        }
        return this._cacheKeyHead + ":" + key;
    }
}

