/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.boot.web;

import org.noear.solon.Utils;
import org.noear.solon.boot.ServerProps;
import org.noear.solon.boot.web.SessionProp;
import org.noear.solon.core.handle.Context;
import org.noear.solon.core.handle.SessionState;

public abstract class SessionStateBase
implements SessionState {
    protected static int _expiry = 7200;
    protected static String _domain = null;
    protected final Context ctx;

    protected SessionStateBase(Context ctx) {
        this.ctx = ctx;
    }

    protected String cookieGet(String key) {
        return this.ctx.cookie(key);
    }

    protected void cookieSet(String key, String val) {
        if (this.ctx.url() == null) {
            return;
        }
        if (SessionProp.session_state_domain_auto && _domain != null && this.ctx.uri().getHost().indexOf(_domain) < 0) {
            this.ctx.cookieSet(key, val, null, _expiry);
            return;
        }
        this.ctx.cookieSet(key, val, _domain, _expiry);
    }

    protected String sessionIdGet(boolean reset) {
        String sid = this.cookieGet(ServerProps.session_cookieName);
        if (!reset && !Utils.isEmpty((String)sid) && sid.length() > 30) {
            return sid;
        }
        sid = Utils.guid();
        this.cookieSet(ServerProps.session_cookieName, sid);
        return sid;
    }

    protected String sessionIdPush() {
        String skey = this.cookieGet(ServerProps.session_cookieName);
        if (Utils.isNotEmpty((String)skey)) {
            this.cookieSet(ServerProps.session_cookieName, skey);
        }
        return skey;
    }

    static {
        if (SessionProp.session_timeout > 0) {
            _expiry = SessionProp.session_timeout;
        }
        if (SessionProp.session_state_domain != null) {
            _domain = SessionProp.session_state_domain;
        }
    }
}

