/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.boot.websocket;

import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import org.java_websocket.WebSocket;
import org.java_websocket.handshake.ClientHandshake;
import org.java_websocket.server.WebSocketServer;
import org.noear.solon.Solon;
import org.noear.solon.boot.websocket._SocketServerSession;
import org.noear.solon.core.event.EventBus;
import org.noear.solon.core.message.Message;
import org.noear.solon.core.message.Session;
import org.noear.solon.socketd.ListenerProxy;
import org.noear.solon.socketd.ProtocolManager;

public class WsServer
extends WebSocketServer {
    public WsServer(int port) {
        super(new InetSocketAddress(port));
    }

    public void onStart() {
        System.out.println("Solon.Server:Websocket onStart...");
    }

    public void onOpen(WebSocket conn, ClientHandshake shake) {
        if (conn == null) {
            return;
        }
        Session session = _SocketServerSession.get(conn);
        shake.iterateHttpFields().forEachRemaining(k -> session.headerSet(k, shake.getFieldValue(k)));
        ListenerProxy.getGlobal().onOpen(session);
    }

    public void onClose(WebSocket conn, int i, String s, boolean b) {
        if (conn == null) {
            return;
        }
        ListenerProxy.getGlobal().onClose(_SocketServerSession.get(conn));
        _SocketServerSession.remove(conn);
    }

    public void onMessage(WebSocket conn, String data) {
        if (conn == null) {
            return;
        }
        try {
            Session session = _SocketServerSession.get(conn);
            Message message = Message.wrap((String)conn.getResourceDescriptor(), null, (String)data);
            ListenerProxy.getGlobal().onMessage(session, message.isString(true));
        }
        catch (Throwable ex) {
            EventBus.push((Object)ex);
        }
    }

    public void onMessage(WebSocket conn, ByteBuffer data) {
        if (conn == null) {
            return;
        }
        try {
            Session session = _SocketServerSession.get(conn);
            Message message = null;
            message = Solon.global().enableWebSocketD() ? ProtocolManager.decode((ByteBuffer)data) : Message.wrap((String)conn.getResourceDescriptor(), null, (byte[])data.array());
            ListenerProxy.getGlobal().onMessage(session, message);
        }
        catch (Throwable ex) {
            EventBus.push((Object)ex);
        }
    }

    public void onError(WebSocket conn, Exception ex) {
        if (conn == null) {
            return;
        }
        ListenerProxy.getGlobal().onError(_SocketServerSession.get(conn), (Throwable)ex);
    }
}

