/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.boot.websocket;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.java_websocket.WebSocket;
import org.noear.solon.Solon;
import org.noear.solon.Utils;
import org.noear.solon.core.handle.MethodType;
import org.noear.solon.core.message.Message;
import org.noear.solon.core.message.Session;
import org.noear.solon.extend.socketd.MessageUtils;
import org.noear.solon.extend.socketd.MessageWrapper;
import org.noear.solon.extend.socketd.SessionBase;

public class _SocketServerSession
extends SessionBase {
    public static Map<WebSocket, Session> sessions = new HashMap<WebSocket, Session>();
    WebSocket real;
    private String _sessionId = Utils.guid();
    private URI _uri;
    private String _path;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Session get(WebSocket real) {
        Object tmp = sessions.get(real);
        if (tmp == null) {
            WebSocket webSocket = real;
            synchronized (webSocket) {
                tmp = sessions.get(real);
                if (tmp == null) {
                    tmp = new _SocketServerSession(real);
                    sessions.put(real, (Session)tmp);
                }
            }
        }
        return tmp;
    }

    public static void remove(WebSocket real) {
        sessions.remove(real);
    }

    public _SocketServerSession(WebSocket real) {
        this.real = real;
    }

    public Object real() {
        return this.real;
    }

    public String sessionId() {
        return this._sessionId;
    }

    public MethodType method() {
        return MethodType.WEBSOCKET;
    }

    public URI uri() {
        if (this._uri == null) {
            this._uri = URI.create(this.real.getResourceDescriptor());
        }
        return this._uri;
    }

    public String path() {
        if (this._path == null) {
            this._path = this.real.getResourceDescriptor();
        }
        return this._path;
    }

    public void send(String message) {
        if (Solon.global().enableWebSocketD()) {
            this.sendBytes(MessageUtils.encode((Message)MessageWrapper.wrap((byte[])message.getBytes(StandardCharsets.UTF_8))).array());
        } else {
            this.real.send(message);
        }
    }

    public void send(byte[] message) {
        if (Solon.global().enableWebSocketD()) {
            this.sendBytes(MessageUtils.encode((Message)MessageWrapper.wrap((byte[])message)).array());
        } else {
            this.sendBytes(message);
        }
    }

    public void send(Message message) {
        super.send(message);
        if (Solon.global().enableWebSocketD()) {
            this.sendBytes(MessageUtils.encode((Message)message).array());
        } else {
            this.sendBytes(message.body());
        }
    }

    private void sendBytes(byte[] message) {
        this.real.send(message);
    }

    public void close() throws IOException {
        this.real.close();
        sessions.remove(this.real);
    }

    public boolean isValid() {
        return this.real.isOpen();
    }

    public boolean isSecure() {
        return this.real.hasSSLSupport();
    }

    public InetSocketAddress getRemoteAddress() {
        return this.real.getRemoteSocketAddress();
    }

    public InetSocketAddress getLocalAddress() {
        return this.real.getLocalSocketAddress();
    }

    public void setAttachment(Object obj) {
        this.real.setAttachment(obj);
    }

    public <T> T getAttachment() {
        return (T)this.real.getAttachment();
    }

    public Collection<Session> getOpenSessions() {
        return new ArrayList<Session>(sessions.values());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        _SocketServerSession that = (_SocketServerSession)((Object)o);
        return Objects.equals(this.real, that.real);
    }

    public int hashCode() {
        return Objects.hash(this.real);
    }
}

