/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.boot.websocket;

import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.java_websocket.WebSocket;
import org.java_websocket.handshake.ClientHandshake;
import org.java_websocket.server.WebSocketServer;
import org.noear.solon.boot.websocket._SocketSession;
import org.noear.solon.core.XEventBus;
import org.noear.solon.core.XListener;
import org.noear.solon.core.XMessage;
import org.noear.solon.core.XMethod;
import org.noear.solon.core.XSession;
import org.noear.solon.extend.xsocket.XListenerProxy;
import org.noear.solon.extend.xsocket.XSocketContextHandler;

public class WsServer
extends WebSocketServer {
    private Charset _charset = StandardCharsets.UTF_8;
    private XSocketContextHandler handler = new XSocketContextHandler(XMethod.WEBSOCKET);
    private XListener listener = XListenerProxy.getGlobal();

    public WsServer(int port) {
        super(new InetSocketAddress(port));
    }

    public void onStart() {
        System.out.println("Solon.Server:Websocket onStart...");
    }

    public void onOpen(WebSocket conn, ClientHandshake shake) {
        this.listener.onOpen(_SocketSession.get(conn));
    }

    public void onClose(WebSocket conn, int i, String s, boolean b) {
        this.listener.onClose(_SocketSession.get(conn));
        _SocketSession.remove(conn);
    }

    public void onMessage(WebSocket conn, String data) {
        try {
            XSession session = _SocketSession.get(conn);
            XMessage message = XMessage.wrap((String)conn.getResourceDescriptor(), (byte[])data.getBytes(this._charset));
            this.listener.onMessage(session, message);
            if (!message.getHandled()) {
                this.handler.handle(session, message, true);
            }
        }
        catch (Throwable ex) {
            XEventBus.push((Object)ex);
        }
    }

    public void onMessage(WebSocket conn, ByteBuffer data) {
        try {
            XSession session = _SocketSession.get(conn);
            XMessage message = XMessage.wrap((String)conn.getResourceDescriptor(), (byte[])data.array());
            this.listener.onMessage(session, message);
            if (!message.getHandled()) {
                this.handler.handle(session, message, false);
            }
        }
        catch (Throwable ex) {
            XEventBus.push((Object)ex);
        }
    }

    public void onError(WebSocket conn, Exception ex) {
        this.listener.onError(_SocketSession.get(conn), (Throwable)ex);
    }
}

