/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.boot.websocket;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.URI;
import org.java_websocket.WebSocket;
import org.noear.solon.core.SocketMessage;
import org.noear.solon.core.XContextEmpty;
import org.noear.solon.core.XMethod;

public class WsContext
extends XContextEmpty {
    private InetSocketAddress _inetSocketAddress;
    private WebSocket _socket;
    private SocketMessage _message;
    private boolean _messageIsString;
    private URI _uri;
    ByteArrayOutputStream _outputStream = new ByteArrayOutputStream();

    public WsContext(WebSocket socket, SocketMessage message, boolean messageIsString) {
        this._socket = socket;
        this._message = message;
        this._inetSocketAddress = socket.getRemoteSocketAddress();
        this._messageIsString = messageIsString;
    }

    public Object request() {
        return this._socket;
    }

    public String ip() {
        if (this._inetSocketAddress == null) {
            return null;
        }
        return this._inetSocketAddress.getAddress().toString();
    }

    public boolean isMultipart() {
        return false;
    }

    public String method() {
        return XMethod.WEBSOCKET.name;
    }

    public String protocol() {
        return "WS";
    }

    public URI uri() {
        if (this._uri == null) {
            this._uri = URI.create(this.url());
        }
        return this._uri;
    }

    public String path() {
        return this.uri().getPath();
    }

    public String url() {
        return this._message.resourceDescriptor;
    }

    public long contentLength() {
        return 0L;
    }

    public String contentType() {
        return null;
    }

    public InputStream bodyAsStream() throws IOException {
        return new ByteArrayInputStream(this._message.content);
    }

    public Object response() {
        return this._socket;
    }

    public void contentType(String contentType) {
        this.headerSet("Content-Type", contentType);
    }

    public OutputStream outputStream() {
        return this._outputStream;
    }

    public void output(String str) {
        try {
            this._outputStream.write(str.getBytes(this._charset));
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public void output(InputStream stream) {
        try {
            byte[] buff = new byte[100];
            int rc = 0;
            while ((rc = stream.read(buff, 0, 100)) > 0) {
                this._outputStream.write(buff, 0, rc);
            }
        }
        catch (Throwable ex) {
            throw new RuntimeException(ex);
        }
    }

    protected void commit() throws IOException {
        if (this._socket.isOpen()) {
            if (this._messageIsString) {
                this._socket.send(new String(this._outputStream.toByteArray()));
            } else {
                this._socket.send(this._outputStream.toByteArray());
            }
        }
    }

    public void close() throws IOException {
        this._socket.close();
    }
}

