/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.boot.websocket.netty;

import org.noear.solon.Solon;
import org.noear.solon.SolonApp;
import org.noear.solon.Utils;
import org.noear.solon.boot.ServerProps;
import org.noear.solon.boot.prop.impl.WebSocketServerProps;
import org.noear.solon.boot.websocket.netty.WsServer;
import org.noear.solon.core.AppContext;
import org.noear.solon.core.Plugin;
import org.noear.solon.core.Signal;
import org.noear.solon.core.SignalSim;
import org.noear.solon.core.SignalType;
import org.noear.solon.core.util.LogUtil;

public class XPluginImpl
implements Plugin {
    private static Signal _signal;
    WsServer _server;

    public static Signal signal() {
        return _signal;
    }

    public static String solon_boot_ver() {
        return "netty-webscoket 4.1.75/" + Solon.version();
    }

    public void start(AppContext context) throws Throwable {
        if (!Solon.app().enableWebSocket()) {
            return;
        }
        context.lifecycle(99, () -> this.start0(Solon.app()));
    }

    private void start0(SolonApp app) throws Throwable {
        ServerProps.init();
        WebSocketServerProps props = WebSocketServerProps.getInstance();
        String _host = props.getHost();
        int _port = props.getPort();
        long time_start = System.currentTimeMillis();
        this._server = new WsServer(props);
        this._server.start(_host, _port);
        if (Utils.isNotEmpty((String)props.getName())) {
            String _wrapHost = props.getWrapHost();
            int _wrapPort = props.getWrapPort();
            _signal = new SignalSim(props.getName(), _wrapHost, _wrapPort, "ws", SignalType.WEBSOCKET);
            app.signalAdd(_signal);
        }
        long time_end = System.currentTimeMillis();
        String wsServerUrl = props.buildWsServerUrl(false);
        LogUtil.global().info("Connector:main: netty-websocket: Started ServerConnector@{HTTP/1.1,[WebSocket]}{" + wsServerUrl + "}");
        LogUtil.global().info("Server:main: netty-websocket: Started (" + XPluginImpl.solon_boot_ver() + ") @" + (time_end - time_start) + "ms");
    }

    public void stop() throws Throwable {
        if (this._server == null) {
            return;
        }
        this._server.stop();
        this._server = null;
        LogUtil.global().info("Server:main: netty-webscoket: Has Stopped (" + XPluginImpl.solon_boot_ver() + ")");
    }
}

