/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.boot.smarthttp.http;

import java.io.IOException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;
import org.noear.solon.boot.ServerProps;
import org.noear.solon.boot.smarthttp.XPluginImp;
import org.noear.solon.boot.smarthttp.http.SmHttpContext;
import org.noear.solon.boot.web.FormUrlencodedUtils;
import org.noear.solon.core.handle.Context;
import org.noear.solon.core.handle.ContextAsyncListener;
import org.noear.solon.core.handle.Handler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.smartboot.http.common.enums.HttpStatus;
import org.smartboot.http.server.HttpRequest;
import org.smartboot.http.server.HttpResponse;
import org.smartboot.http.server.HttpServerHandler;
import org.smartboot.http.server.impl.Request;
import org.smartboot.socket.util.AttachKey;
import org.smartboot.socket.util.Attachment;

public class SmHttpContextHandler
extends HttpServerHandler {
    static final Logger log = LoggerFactory.getLogger(SmHttpContextHandler.class);
    static final AttachKey<SmHttpContext> httpHolderKey = AttachKey.valueOf((String)"httpHolder");
    protected Executor executor;
    private final Handler handler;

    public SmHttpContextHandler(Handler handler) {
        this.handler = handler;
    }

    public void setExecutor(Executor executor) {
        this.executor = executor;
    }

    public void onClose(Request request) {
        if (request.getAttachment() == null) {
            return;
        }
        SmHttpContext ctx = (SmHttpContext)((Object)request.getAttachment().get(httpHolderKey));
        if (ctx != null && ctx.innerIsAsync()) {
            for (ContextAsyncListener listener : ctx.innerAsyncListeners()) {
                try {
                    listener.onComplete((Context)ctx);
                }
                catch (Throwable e) {
                    log.warn(e.getMessage(), e);
                }
            }
        }
    }

    public void handle(HttpRequest request, HttpResponse response, CompletableFuture<Object> future) throws IOException {
        SmHttpContext ctx = new SmHttpContext(request, response, future);
        if (request.getAttachment() == null) {
            request.setAttachment(new Attachment());
        }
        request.getAttachment().put(httpHolderKey, (Object)ctx);
        if (this.executor == null) {
            this.handle0(ctx, future);
        } else {
            try {
                this.executor.execute(() -> this.handle0(ctx, future));
            }
            catch (RejectedExecutionException e) {
                this.handle0(ctx, future);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handle0(SmHttpContext ctx, CompletableFuture<Object> future) {
        try {
            this.handleDo(ctx);
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        finally {
            if (!ctx.innerIsAsync()) {
                future.complete((Object)ctx);
            }
        }
    }

    protected void handleDo(SmHttpContext ctx) {
        try {
            if ("PRI".equals(ctx.method())) {
                ctx.innerGetResponse().setHttpStatus(HttpStatus.NOT_IMPLEMENTED);
                return;
            }
            ctx.contentType("text/plain;charset=UTF-8");
            if (ServerProps.output_meta) {
                ctx.headerSet("Solon-Boot", XPluginImp.solon_boot_ver());
            }
            FormUrlencodedUtils.pretreatment((Context)ctx);
            this.handler.handle((Context)ctx);
            if (!ctx.innerIsAsync()) {
                ctx.innerCommit();
            }
        }
        catch (Throwable e) {
            log.warn(e.getMessage(), e);
            ctx.innerGetResponse().setHttpStatus(HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }
}

