/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.boot.smarthttp.http;

import java.io.IOException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;
import org.noear.solon.boot.ServerProps;
import org.noear.solon.boot.smarthttp.XPluginImp;
import org.noear.solon.boot.smarthttp.http.HttpHolder;
import org.noear.solon.boot.smarthttp.http.SmHttpContext;
import org.noear.solon.core.event.EventBus;
import org.noear.solon.core.handle.Context;
import org.noear.solon.core.handle.Handler;
import org.smartboot.http.common.enums.HttpStatus;
import org.smartboot.http.server.HttpRequest;
import org.smartboot.http.server.HttpResponse;
import org.smartboot.http.server.HttpServerHandler;

public class SmHttpContextHandler
extends HttpServerHandler {
    protected Executor executor;
    private final Handler handler;

    public SmHttpContextHandler(Handler handler) {
        this.handler = handler;
    }

    public void setExecutor(Executor executor) {
        this.executor = executor;
    }

    public void handle(HttpRequest request, HttpResponse response, CompletableFuture<Object> future) throws IOException {
        if (this.executor == null) {
            this.handle0(request, response, future);
        } else {
            try {
                this.executor.execute(() -> this.handle0(request, response, future));
            }
            catch (RejectedExecutionException e) {
                this.handle0(request, response, future);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handle0(HttpRequest request, HttpResponse response, CompletableFuture<Object> future) {
        HttpHolder httpHolder = new HttpHolder(request, future);
        try {
            this.handleDo(httpHolder, response);
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        finally {
            if (!httpHolder.isAsync()) {
                httpHolder.complete();
            }
        }
    }

    protected void handleDo(HttpHolder httpHolder, HttpResponse response) {
        try {
            if ("PRI".equals(httpHolder.getRequest().getMethod())) {
                response.setHttpStatus(HttpStatus.NOT_IMPLEMENTED);
                return;
            }
            SmHttpContext ctx = new SmHttpContext(httpHolder, response);
            ctx.contentType("text/plain;charset=UTF-8");
            if (ServerProps.output_meta) {
                ctx.headerSet("Solon-Boot", XPluginImp.solon_boot_ver());
            }
            this.handler.handle((Context)ctx);
            if (ctx.getHandled() || ctx.status() >= 200) {
                ctx.commit();
            } else {
                ctx.status(404);
                ctx.commit();
            }
        }
        catch (Throwable e) {
            EventBus.pushTry((Object)e);
            response.setHttpStatus(HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }
}

