/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.boot.smarthttp.http;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.noear.solon.Utils;
import org.noear.solon.boot.smarthttp.http.MultipartUtil;
import org.noear.solon.boot.web.ContextBase;
import org.noear.solon.boot.web.RedirectUtils;
import org.noear.solon.core.NvMap;
import org.noear.solon.core.event.EventBus;
import org.noear.solon.core.handle.UploadedFile;
import org.smartboot.http.common.Cookie;
import org.smartboot.http.common.enums.HttpStatus;
import org.smartboot.http.server.HttpRequest;
import org.smartboot.http.server.HttpResponse;

public class SmHttpContext
extends ContextBase {
    private HttpRequest _request;
    private HttpResponse _response;
    protected Map<String, List<UploadedFile>> _fileMap;
    private boolean _loadMultipartFormData = false;
    private String _ip;
    private URI _uri;
    private String _url;
    private NvMap _paramMap;
    private Map<String, List<String>> _paramsMap;
    private NvMap _cookieMap;
    private NvMap _headerMap;
    private ByteArrayOutputStream _outputStreamTmp;
    private int _status = 200;
    private boolean _headers_sent = false;
    private boolean _allows_write = true;

    public SmHttpContext(HttpRequest request, HttpResponse response) {
        this._request = request;
        this._response = response;
        this._fileMap = new HashMap<String, List<UploadedFile>>();
    }

    private void loadMultipartFormData() throws IOException {
        if (this._loadMultipartFormData) {
            return;
        }
        this._loadMultipartFormData = true;
        if (this.isMultipartFormData()) {
            MultipartUtil.buildParamsAndFiles(this);
        }
    }

    public Object request() {
        return this._request;
    }

    public String ip() {
        if (this._ip == null) {
            this._ip = this.header("X-Forwarded-For");
            if (this._ip == null) {
                this._ip = this._request.getRemoteAddr();
            }
        }
        return this._ip;
    }

    public String method() {
        return this._request.getMethod();
    }

    public String protocol() {
        return this._request.getProtocol();
    }

    public URI uri() {
        if (this._uri == null) {
            this._uri = URI.create(this.url());
        }
        return this._uri;
    }

    public String url() {
        if (this._url == null) {
            this._url = this._request.getRequestURL();
        }
        return this._url;
    }

    public long contentLength() {
        try {
            return this._request.getContentLength();
        }
        catch (Exception e) {
            EventBus.pushTry((Object)e);
            return 0L;
        }
    }

    public String queryString() {
        return this._request.getQueryString();
    }

    public InputStream bodyAsStream() throws IOException {
        return this._request.getInputStream();
    }

    public String[] paramValues(String key) {
        return this._request.getParameterValues(key);
    }

    public String param(String key) {
        return (String)this.paramMap().get((Object)key);
    }

    public NvMap paramMap() {
        if (this._paramMap == null) {
            this._paramMap = new NvMap();
            try {
                if (this.autoMultipart()) {
                    this.loadMultipartFormData();
                }
                for (Map.Entry entry : this._request.getParameters().entrySet()) {
                    this._paramMap.put((String)entry.getKey(), (Object)((String[])entry.getValue())[0]);
                }
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Throwable e) {
                throw new RuntimeException(e);
            }
        }
        return this._paramMap;
    }

    public Map<String, List<String>> paramsMap() {
        if (this._paramsMap == null) {
            this._paramsMap = new LinkedHashMap<String, List<String>>();
            this._request.getParameters().forEach((k, v) -> this._paramsMap.put((String)k, Arrays.asList(v)));
        }
        return this._paramsMap;
    }

    public Map<String, List<UploadedFile>> filesMap() throws IOException {
        if (this.isMultipartFormData()) {
            this.loadMultipartFormData();
            return this._fileMap;
        }
        return Collections.emptyMap();
    }

    public NvMap cookieMap() {
        if (this._cookieMap == null) {
            this._cookieMap = new NvMap();
            String _cookieMapStr = this.header("Cookie");
            if (_cookieMapStr != null) {
                String[] cookies;
                for (String c1 : cookies = _cookieMapStr.split(";")) {
                    String[] ss = c1.trim().split("=");
                    if (ss.length != 2) continue;
                    this._cookieMap.put(ss[0].trim(), (Object)ss[1].trim());
                }
            }
        }
        return this._cookieMap;
    }

    public NvMap headerMap() {
        if (this._headerMap == null) {
            this._headerMap = new NvMap();
            for (String k : this._request.getHeaderNames()) {
                this._headerMap.put(k, (Object)this._request.getHeader(k));
            }
        }
        return this._headerMap;
    }

    public Object response() {
        return this._response;
    }

    protected void contentTypeDoSet(String contentType) {
        if (this.charset != null && contentType.indexOf(";") < 0) {
            this.headerSet("Content-Type", contentType + ";charset=" + this.charset);
            return;
        }
        this.headerSet("Content-Type", contentType);
    }

    public OutputStream outputStream() throws IOException {
        this.sendHeaders(false);
        if (this._allows_write) {
            return this._response.getOutputStream();
        }
        if (this._outputStreamTmp == null) {
            this._outputStreamTmp = new ByteArrayOutputStream();
        } else {
            this._outputStreamTmp.reset();
        }
        return this._outputStreamTmp;
    }

    public void output(byte[] bytes) {
        try {
            OutputStream out = this.outputStream();
            if (!this._allows_write) {
                return;
            }
            out.write(bytes);
        }
        catch (Throwable ex) {
            throw new RuntimeException(ex);
        }
    }

    public void output(InputStream stream) {
        try {
            OutputStream out = this.outputStream();
            if (!this._allows_write) {
                return;
            }
            Utils.transferTo((InputStream)stream, (OutputStream)out);
        }
        catch (Throwable ex) {
            throw new RuntimeException(ex);
        }
    }

    public void headerSet(String key, String val) {
        this._response.setHeader(key, val);
    }

    public void headerAdd(String key, String val) {
        this._response.addHeader(key, val);
    }

    public void cookieSet(String key, String val, String domain, String path, int maxAge) {
        Cookie cookie = new Cookie(key, val);
        if (Utils.isNotEmpty((String)path)) {
            cookie.setPath(path);
        }
        if (maxAge >= 0) {
            cookie.setMaxAge(Integer.valueOf(maxAge));
        }
        if (Utils.isNotEmpty((String)domain)) {
            cookie.setDomain(domain);
        }
        this._response.addCookie(cookie);
    }

    public void redirect(String url, int code) {
        url = RedirectUtils.getRedirectPath((String)url);
        this.headerSet("Location", url);
        this.statusDoSet(code);
    }

    public int status() {
        return this._status;
    }

    protected void statusDoSet(int status) {
        this._status = status;
    }

    public void contentLength(long size) {
        this._response.setContentLength((int)size);
    }

    public void flush() throws IOException {
        if (this._allows_write) {
            this.outputStream().flush();
        }
    }

    protected void commit() throws IOException {
        this.sendHeaders(true);
    }

    private void sendHeaders(boolean isCommit) throws IOException {
        if (!this._headers_sent) {
            this._headers_sent = true;
            if ("HEAD".equals(this.method())) {
                this._allows_write = false;
            }
            if (this.sessionState() != null) {
                this.sessionState().sessionPublish();
            }
            this._response.setHttpStatus(HttpStatus.valueOf((int)this.status()));
            if (isCommit || !this._allows_write) {
                this._response.setContentLength(0);
            }
        }
    }
}

