/*
 * Decompiled with CFR 0.152.
 */
package org.smartboot.http.server.impl;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import org.smartboot.http.common.logging.Logger;
import org.smartboot.http.common.logging.LoggerFactory;
import org.smartboot.http.server.WebSocketResponse;
import org.smartboot.http.server.impl.AbstractResponse;
import org.smartboot.http.server.impl.Request;
import org.smartboot.http.server.impl.WebSocketOutputStream;
import org.smartboot.http.server.impl.WebSocketRequestImpl;

public class WebSocketResponseImpl
extends AbstractResponse
implements WebSocketResponse {
    private static final Logger LOGGER = LoggerFactory.getLogger(WebSocketResponseImpl.class);

    public WebSocketResponseImpl(WebSocketRequestImpl webSocketRequest, Request request) {
        this.init(webSocketRequest, new WebSocketOutputStream(webSocketRequest, this, request));
    }

    @Override
    public void sendTextMessage(String text) {
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("\u53d1\u9001\u5b57\u7b26\u4e32\u6d88\u606f: " + text);
        }
        byte[] bytes = text.getBytes(StandardCharsets.UTF_8);
        try {
            this.send((byte)1, bytes, 0, bytes.length);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void sendBinaryMessage(byte[] bytes) {
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("\u53d1\u9001\u4e8c\u8fdb\u5236\u6d88\u606f: " + Arrays.toString(bytes));
        }
        try {
            this.send((byte)2, bytes, 0, bytes.length);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void sendBinaryMessage(byte[] bytes, int offset, int length) {
        try {
            this.send((byte)2, bytes, offset, length);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void flush() {
        try {
            this.getOutputStream().flush();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void send(byte opCode, byte[] bytes, int offset, int len) throws IOException {
        int maxlength = len < 126 ? 2 + len : 32771;
        byte[] writBytes = new byte[maxlength];
        while (offset < len) {
            int length = len - offset;
            if (length > Short.MAX_VALUE) {
                length = Short.MAX_VALUE;
            }
            int firstByte = offset + length < len ? 0 : -128;
            firstByte = offset == 0 ? (int)((byte)(firstByte | opCode)) : (int)((byte)(firstByte | 0));
            int secondByte = length < 126 ? (int)length : 126;
            writBytes[0] = firstByte;
            writBytes[1] = secondByte;
            if (secondByte == 126) {
                writBytes[2] = (byte)(length >> 8 & 0xFF);
                writBytes[3] = (byte)(length & 0xFF);
                System.arraycopy(bytes, offset, writBytes, 4, length);
            } else {
                System.arraycopy(bytes, offset, writBytes, 2, length);
            }
            this.getOutputStream().write(writBytes, 0, length < 126 ? 2 + length : 4 + length);
            offset += length;
        }
    }
}

