/*
 * Decompiled with CFR 0.152.
 */
package org.smartboot.http.server.impl;

import java.nio.ByteBuffer;
import org.smartboot.http.server.HttpServerConfiguration;
import org.smartboot.http.server.decode.Decoder;
import org.smartboot.http.server.decode.HttpMethodDecoder;
import org.smartboot.http.server.impl.Request;
import org.smartboot.http.server.impl.RequestAttachment;
import org.smartboot.socket.Protocol;
import org.smartboot.socket.transport.AioSession;

public class HttpRequestProtocol
implements Protocol<Request> {
    public static final Decoder BODY_READY_DECODER = (byteBuffer, aioSession, response) -> null;
    public static final Decoder BODY_CONTINUE_DECODER = (byteBuffer, aioSession, response) -> null;
    private final HttpMethodDecoder httpMethodDecoder;

    public HttpRequestProtocol(HttpServerConfiguration configuration) {
        this.httpMethodDecoder = new HttpMethodDecoder(configuration);
    }

    public Request decode(ByteBuffer buffer, AioSession session) {
        if (buffer.remaining() == 0) {
            return null;
        }
        RequestAttachment attachment = (RequestAttachment)session.getAttachment();
        Request request = attachment.getRequest();
        Decoder decodeChain = attachment.getDecoder();
        if (decodeChain == null) {
            decodeChain = this.httpMethodDecoder;
        }
        if (decodeChain == BODY_CONTINUE_DECODER) {
            attachment.setDecoder(BODY_READY_DECODER);
            return null;
        }
        if (decodeChain == BODY_READY_DECODER) {
            return request;
        }
        decodeChain = decodeChain.decode(buffer, session, request);
        attachment.setDecoder(decodeChain);
        if (decodeChain == BODY_READY_DECODER) {
            return request;
        }
        if (buffer.remaining() == buffer.capacity()) {
            throw new RuntimeException("buffer is too small when decode " + decodeChain.getClass().getName() + " ," + request);
        }
        return null;
    }
}

