/*
 * Decompiled with CFR 0.152.
 */
package org.smartboot.http.server.handle;

import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import org.smartboot.http.WebSocketRequest;
import org.smartboot.http.WebSocketResponse;
import org.smartboot.http.logging.RunLogger;
import org.smartboot.http.server.handle.WebSocketHandle;
import org.smartboot.http.utils.AntPathMatcher;

public final class WebSocketRouteHandle
extends WebSocketHandle {
    private static final AntPathMatcher PATH_MATCHER = new AntPathMatcher();
    private Map<String, WebSocketHandle> handleMap = new ConcurrentHashMap<String, WebSocketHandle>();
    private WebSocketHandle defaultHandle = new WebSocketHandle(){

        @Override
        public void doHandle(WebSocketRequest request, WebSocketResponse response) throws IOException {
            RunLogger.getLogger().log(Level.WARNING, "not found");
        }
    };

    @Override
    public void doHandle(WebSocketRequest request, WebSocketResponse response) throws IOException {
        String uri = request.getRequestURI();
        WebSocketHandle httpHandle = this.handleMap.get(uri);
        if (httpHandle == null) {
            for (Map.Entry<String, WebSocketHandle> entity : this.handleMap.entrySet()) {
                if (!PATH_MATCHER.match(entity.getKey(), uri)) continue;
                httpHandle = entity.getValue();
                break;
            }
            if (httpHandle == null) {
                httpHandle = this.defaultHandle;
            }
            this.handleMap.put(uri, httpHandle);
        }
        httpHandle.doHandle(request, response);
    }

    public WebSocketRouteHandle route(String urlPattern, WebSocketHandle httpHandle) {
        this.handleMap.put(urlPattern, httpHandle);
        return this;
    }
}

