/*
 * Decompiled with CFR 0.152.
 */
package org.smartboot.http.server;

import java.io.IOException;
import java.util.Base64;
import org.smartboot.http.WebSocketRequest;
import org.smartboot.http.WebSocketResponse;
import org.smartboot.http.enums.HttpStatus;
import org.smartboot.http.enums.WebsocketStatus;
import org.smartboot.http.server.RFC2612RequestHandle;
import org.smartboot.http.server.WebSocketRequestImpl;
import org.smartboot.http.server.WebSocketResponseImpl;
import org.smartboot.http.server.handle.WebSocketHandle;
import org.smartboot.http.utils.SHA1;

class WebSocketHandSharkHandle
extends WebSocketHandle {
    public static final String WEBSOCKET_13_ACCEPT_GUID = "258EAFA5-E914-47DA-95CA-C5AB0DC85B11";
    private final RFC2612RequestHandle rfc2612RequestHandle = new RFC2612RequestHandle();

    WebSocketHandSharkHandle() {
    }

    @Override
    public void doHandle(WebSocketRequest req, WebSocketResponse resp) throws IOException {
        WebSocketResponseImpl response = (WebSocketResponseImpl)resp;
        WebSocketRequestImpl request = (WebSocketRequestImpl)req;
        if (request.getWebsocketStatus() == WebsocketStatus.HandShake) {
            this.rfc2612RequestHandle.doHandle(request, response);
            String key = request.getHeader("Sec-WebSocket-Key");
            String acceptSeed = key + WEBSOCKET_13_ACCEPT_GUID;
            byte[] sha1 = SHA1.encode(acceptSeed);
            String accept = Base64.getEncoder().encodeToString(sha1);
            response.setHttpStatus(HttpStatus.SWITCHING_PROTOCOLS);
            response.setHeader("Upgrade", "websocket");
            response.setHeader("Connection", "Upgrade");
            response.setHeader("Sec-WebSocket-Accept", accept);
            response.getOutputStream().flush();
            this.doNext(request, response);
            request.setWebsocketStatus(WebsocketStatus.DataFrame);
        } else {
            this.doNext(request, response);
        }
    }
}

