/*
 * Decompiled with CFR 0.152.
 */
package org.smartboot.http.server.handle;

import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.smartboot.http.HttpRequest;
import org.smartboot.http.HttpResponse;
import org.smartboot.http.enums.HttpStatus;
import org.smartboot.http.server.handle.HttpHandle;
import org.smartboot.http.utils.AntPathMatcher;

public final class HttpRouteHandle
extends HttpHandle {
    private static final AntPathMatcher PATH_MATCHER = new AntPathMatcher();
    private Map<String, HttpHandle> handleMap = new ConcurrentHashMap<String, HttpHandle>();
    private HttpHandle defaultHandle = new HttpHandle(){

        @Override
        public void doHandle(HttpRequest request, HttpResponse response) throws IOException {
            response.setHttpStatus(HttpStatus.NOT_FOUND);
        }
    };

    @Override
    public void doHandle(HttpRequest request, HttpResponse response) throws IOException {
        String uri = request.getRequestURI();
        HttpHandle httpHandle = this.handleMap.get(uri);
        if (httpHandle == null) {
            for (Map.Entry<String, HttpHandle> entity : this.handleMap.entrySet()) {
                if (!PATH_MATCHER.match(entity.getKey(), uri)) continue;
                httpHandle = entity.getValue();
                break;
            }
            if (httpHandle == null) {
                httpHandle = this.defaultHandle;
            }
            this.handleMap.put(uri, httpHandle);
        }
        httpHandle.doHandle(request, response);
    }

    public HttpRouteHandle route(String urlPattern, HttpHandle httpHandle) {
        this.handleMap.put(urlPattern, httpHandle);
        return this;
    }
}

