/*
 * Decompiled with CFR 0.152.
 */
package org.smartboot.http.server;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.concurrent.Semaphore;
import org.smartboot.http.HttpRequest;
import org.smartboot.http.enums.HeaderNameEnum;
import org.smartboot.http.enums.HttpMethodEnum;
import org.smartboot.http.server.AbstractResponse;
import org.smartboot.http.server.Reset;
import org.smartboot.http.utils.Constant;
import org.smartboot.http.utils.HttpHeaderConstant;

abstract class AbstractOutputStream
extends OutputStream
implements Reset {
    private static final byte[] CHUNKED_END_BYTES = "0\r\n\r\n".getBytes(StandardCharsets.US_ASCII);
    private static final SimpleDateFormat sdf = new SimpleDateFormat("E, dd MMM yyyy HH:mm:ss z", Locale.ENGLISH);
    private static final Semaphore flushDateSemaphore = new Semaphore(1);
    private static final Date currentDate = new Date(0L);
    protected static byte[] date;
    private static String SERVER_ALIAS_NAME;
    protected final AbstractResponse response;
    protected final OutputStream outputStream;
    private final HttpRequest request;
    protected boolean committed = false;
    protected boolean closed = false;
    protected boolean chunked = false;

    public AbstractOutputStream(HttpRequest request, AbstractResponse response, OutputStream outputStream) {
        this.response = response;
        this.request = request;
        this.outputStream = outputStream;
    }

    protected static void flushDate() {
        if (System.currentTimeMillis() - currentDate.getTime() > 900L && flushDateSemaphore.tryAcquire()) {
            try {
                currentDate.setTime(System.currentTimeMillis());
                date = ("\r\nDate:" + sdf.format(currentDate) + "\r\n" + "Server" + ":" + SERVER_ALIAS_NAME + "\r\n\r\n").getBytes();
            }
            finally {
                flushDateSemaphore.release();
            }
        }
    }

    @Override
    public final void write(int b) {
        throw new UnsupportedOperationException();
    }

    @Override
    public final void write(byte[] b, int off, int len) throws IOException {
        this.writeHead();
        if (HttpMethodEnum.HEAD.getMethod().equals(this.request.getMethod())) {
            throw new UnsupportedOperationException(this.request.getMethod() + " can not write http body");
        }
        if (this.chunked) {
            byte[] start = this.getBytes(Integer.toHexString(len) + "\r\n");
            this.outputStream.write(start);
            this.outputStream.write(b, off, len);
            this.outputStream.write(Constant.CRLF);
        } else {
            this.outputStream.write(b, off, len);
        }
    }

    abstract void writeHead() throws IOException;

    @Override
    public final void flush() throws IOException {
        this.writeHead();
        this.outputStream.flush();
    }

    @Override
    public final void close() throws IOException {
        if (this.closed) {
            throw new IOException("outputStream has already closed");
        }
        this.writeHead();
        if (this.chunked) {
            this.outputStream.write(CHUNKED_END_BYTES);
        }
        this.closed = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final byte[] getHeaderNameBytes(String name) {
        HeaderNameEnum headerNameEnum = HttpHeaderConstant.HEADER_NAME_ENUM_MAP.get(name);
        if (headerNameEnum != null) {
            return headerNameEnum.getBytesWithColon();
        }
        byte[] extBytes = HttpHeaderConstant.HEADER_NAME_EXT_MAP.get(name);
        if (extBytes == null) {
            String string = name;
            synchronized (string) {
                extBytes = this.getBytes("\r\n" + name + ":");
                HttpHeaderConstant.HEADER_NAME_EXT_MAP.put(name, extBytes);
            }
        }
        return extBytes;
    }

    protected final byte[] getBytes(String str) {
        return str.getBytes(StandardCharsets.US_ASCII);
    }

    @Override
    public final void reset() {
        this.chunked = false;
        this.closed = false;
        this.committed = false;
    }

    public final boolean isClosed() {
        return this.closed;
    }

    static {
        SERVER_ALIAS_NAME = "smart-http";
        String aliasServer = System.getProperty("smartHttp.server.alias");
        if (aliasServer != null) {
            SERVER_ALIAS_NAME = aliasServer + "smart-http";
        }
        AbstractOutputStream.flushDate();
    }
}

