/*
 * Decompiled with CFR 0.152.
 */
package org.smartboot.http.logging;

import java.io.File;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import org.smartboot.http.logging.LoggerConfig;
import org.smartboot.http.logging.LoggerStatus;
import org.smartboot.http.logging.LoggerSystemException;

public class RunLogger {
    private static RunLogger runlogger;
    private Logger logger = null;
    private volatile LoggerStatus status = LoggerStatus.UNINITIALIZE;
    private LoggerConfig config;

    private RunLogger() {
        this.logger = Logger.getLogger(RunLogger.class.getName());
        this.logger.setUseParentHandlers(false);
        this.logger.getParent().setLevel(Level.INFO);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static RunLogger getLogger() {
        if (runlogger != null) return runlogger;
        Class<RunLogger> clazz = RunLogger.class;
        synchronized (RunLogger.class) {
            if (runlogger != null) return runlogger;
            runlogger = new RunLogger();
            // ** MonitorExit[var0] (shouldn't be in output)
            return runlogger;
        }
    }

    public synchronized void init(LoggerConfig config) {
        if (LoggerStatus.UNINITIALIZE != this.status && LoggerStatus.TEMP_ENABLED != this.status) {
            throw new LoggerSystemException("could not execute Logger init method,RunLogger's current status is " + (Object)((Object)this.status));
        }
        try {
            File file;
            Handler[] handls = this.logger.getHandlers();
            if (handls != null) {
                for (Handler h : handls) {
                    this.logger.removeHandler(h);
                }
            }
            this.logger.setLevel(config.getLevel());
            if ((config.isLog2File() || config.isErr2File() || config.isOut2File()) && !(file = new File(config.getLogDir())).isDirectory()) {
                file.mkdirs();
            }
            if (config.isLog2File()) {
                this.logger.addHandler(config.getLogFileHandler());
            }
            if (config.isLog2console()) {
                this.logger.addHandler(config.getConsoleHandler());
            }
            if (config.isErr2File()) {
                this.logger.addHandler(config.getErrorFileHandler());
            }
            if (config.isOut2File()) {
                this.logger.addHandler(config.getOutFileHandler());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.config = config;
        this.status = LoggerStatus.ENABLED;
    }

    public void log(Throwable thrown) {
        this.log(Level.WARNING, thrown.getMessage(), thrown);
    }

    public void log(Level level, String msg) {
        this.log(level, msg, null);
    }

    public void log(Level level, String msg, Throwable thrown) {
        if (this.status == LoggerStatus.UNINITIALIZE) {
            this.setInnerLoggerCfg();
            this.status = LoggerStatus.TEMP_ENABLED;
        }
        if (this.status != LoggerStatus.ENABLED && this.status != LoggerStatus.TEMP_ENABLED) {
            throw new LoggerSystemException("RunLogg's status is " + (Object)((Object)this.status));
        }
        LogRecord record = new LogRecord(level, null);
        record.setMessage(msg);
        record.setThrown(thrown);
        this.logger.log(record);
    }

    private void setInnerLoggerCfg() {
        LoggerConfig cfg = new LoggerConfig();
        cfg.setLog2console(true);
        cfg.setLevel(Level.INFO);
        this.init(cfg);
    }

    public Level getLoggerLevel() {
        return this.config.getLevel();
    }
}

