/*
 * Decompiled with CFR 0.152.
 */
package org.smartboot.http.server;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import org.smartboot.http.HttpRequest;
import org.smartboot.http.HttpResponse;
import org.smartboot.http.enums.HttpStatus;
import org.smartboot.http.server.AbstractOutputStream;
import org.smartboot.http.server.HeaderValue;
import org.smartboot.http.server.Reset;

class AbstractResponse
implements HttpResponse,
Reset {
    private AbstractOutputStream outputStream;
    private Map<String, HeaderValue> headers = null;
    private HttpStatus httpStatus;
    private int contentLength = -1;
    private String contentType;
    private HttpRequest request;
    private String characterEncoding;
    private boolean closed = false;

    AbstractResponse() {
    }

    protected void init(HttpRequest request, AbstractOutputStream outputStream) {
        this.request = request;
        this.outputStream = outputStream;
    }

    @Override
    public final void reset() {
        this.outputStream.reset();
        if (this.headers != null) {
            this.headers.clear();
        }
        this.httpStatus = null;
        this.contentType = null;
        this.contentLength = -1;
        this.characterEncoding = null;
        this.closed = false;
    }

    @Override
    public final AbstractOutputStream getOutputStream() {
        return this.outputStream;
    }

    @Override
    public final HttpStatus getHttpStatus() {
        return this.httpStatus;
    }

    @Override
    public final void setHttpStatus(HttpStatus httpStatus) {
        this.httpStatus = httpStatus;
    }

    @Override
    public final void setHeader(String name, String value) {
        this.setHeader(name, value, true);
    }

    @Override
    public final void addHeader(String name, String value) {
        this.setHeader(name, value, false);
    }

    private void setHeader(String name, String value, boolean replace) {
        char cc = name.charAt(0);
        if ((cc == 'C' || cc == 'c') && this.checkSpecialHeader(name, value)) {
            return;
        }
        if (this.headers == null) {
            this.headers = new HashMap<String, HeaderValue>();
        }
        if (replace) {
            this.headers.put(name, new HeaderValue(null, value));
            return;
        }
        HeaderValue headerValue = this.headers.get(name);
        if (headerValue == null) {
            this.setHeader(name, value, true);
            return;
        }
        HeaderValue preHeaderValue = null;
        while (headerValue != null && !headerValue.getValue().equals(value)) {
            preHeaderValue = headerValue;
            headerValue = headerValue.getNextValue();
        }
        if (headerValue == null) {
            preHeaderValue.setNextValue(new HeaderValue(null, value));
        }
    }

    private boolean checkSpecialHeader(String name, String value) {
        if (name.equalsIgnoreCase("Content-Type")) {
            this.setContentType(value);
            return true;
        }
        return false;
    }

    @Override
    public final String getHeader(String name) {
        HeaderValue headerValue = null;
        if (this.headers != null) {
            headerValue = this.headers.get(name);
        }
        return headerValue == null ? null : headerValue.getValue();
    }

    final Map<String, HeaderValue> getHeaders() {
        return this.headers;
    }

    @Override
    public final Collection<String> getHeaders(String name) {
        if (this.headers == null) {
            return Collections.emptyList();
        }
        Vector<String> result = new Vector<String>();
        for (HeaderValue headerValue = this.headers.get(name); headerValue != null; headerValue = headerValue.getNextValue()) {
            result.addElement(headerValue.getValue());
        }
        return result;
    }

    @Override
    public final Collection<String> getHeaderNames() {
        if (this.headers == null) {
            return Collections.emptyList();
        }
        return new ArrayList<String>(this.headers.keySet());
    }

    @Override
    public final void write(byte[] buffer) throws IOException {
        this.outputStream.write(buffer);
    }

    @Override
    public final String getCharacterEncoding() {
        return this.characterEncoding == null ? this.request.getCharacterEncoding() : this.characterEncoding;
    }

    @Override
    public final void setCharacterEncoding(String charset) {
        this.characterEncoding = charset;
    }

    @Override
    public final void close() {
        if (this.closed) {
            return;
        }
        try {
            if (this.outputStream != null && !this.outputStream.isClosed()) {
                this.outputStream.close();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.closed = true;
    }

    public int getContentLength() {
        return this.contentLength;
    }

    @Override
    public void setContentLength(int contentLength) {
        this.contentLength = contentLength;
    }

    public final String getContentType() {
        return this.contentType;
    }

    @Override
    public final void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public final boolean isClosed() {
        return this.closed;
    }
}

