/*
 * Decompiled with CFR 0.152.
 */
package org.smartboot.http;

import java.io.IOException;
import org.smartboot.http.HttpRequest;
import org.smartboot.http.HttpResponse;
import org.smartboot.http.WebSocketRequest;
import org.smartboot.http.WebSocketResponse;
import org.smartboot.http.server.HttpMessageProcessor;
import org.smartboot.http.server.HttpRequestProtocol;
import org.smartboot.http.server.Request;
import org.smartboot.http.server.handle.Pipeline;
import org.smartboot.socket.MessageProcessor;
import org.smartboot.socket.Protocol;
import org.smartboot.socket.buffer.BufferFactory;
import org.smartboot.socket.buffer.BufferPagePool;
import org.smartboot.socket.transport.AioQuickServer;

public class HttpBootstrap {
    private AioQuickServer<Request> server;
    private int port = 8080;
    private int readBufferSize = 1024;
    private int threadNum = Runtime.getRuntime().availableProcessors() + 2;
    private int pageSize = 0x100000;
    private int pageNum = this.threadNum;
    private int writeBufferSize = 1024;
    private String host;
    private boolean bannerEnabled = true;
    private HttpMessageProcessor processor = new HttpMessageProcessor();
    private HttpRequestProtocol protocol = new HttpRequestProtocol();

    public HttpBootstrap setPort(int port) {
        this.port = port;
        return this;
    }

    public HttpBootstrap host(String host) {
        this.host = host;
        return this;
    }

    public Pipeline<HttpRequest, HttpResponse> pipeline() {
        return this.processor.pipeline();
    }

    public Pipeline<WebSocketRequest, WebSocketResponse> wsPipeline() {
        return this.processor.wsPipeline();
    }

    public HttpBootstrap setReadBufferSize(int readBufferSize) {
        this.readBufferSize = readBufferSize;
        return this;
    }

    public HttpBootstrap setThreadNum(int threadNum) {
        this.threadNum = threadNum;
        return this;
    }

    public HttpBootstrap setBufferPool(int pageSize, int pageNum, int chunkSize) {
        this.pageSize = pageSize;
        this.pageNum = pageNum;
        this.writeBufferSize = chunkSize;
        return this;
    }

    public void start() {
        this.server = new AioQuickServer(this.host, this.port, (Protocol)this.protocol, (MessageProcessor)this.processor);
        this.server.setReadBufferSize(this.readBufferSize).setThreadNum(this.threadNum).setBannerEnabled(this.bannerEnabled).setBufferFactory(new BufferFactory(){

            public BufferPagePool create() {
                return new BufferPagePool(HttpBootstrap.this.pageSize, HttpBootstrap.this.pageNum, true);
            }
        }).setWriteBuffer(this.writeBufferSize, 16);
        try {
            this.server.start();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void setBannerEnabled(boolean bannerEnabled) {
        this.bannerEnabled = bannerEnabled;
    }

    public void shutdown() {
        if (this.server != null) {
            this.server.shutdown();
            this.server = null;
        }
    }
}

