/*
 * Decompiled with CFR 0.152.
 */
package org.smartboot.http.server.decode;

import java.nio.ByteBuffer;
import org.smartboot.http.enums.HttpMethodEnum;
import org.smartboot.http.enums.HttpStatus;
import org.smartboot.http.enums.YesNoEnum;
import org.smartboot.http.exception.HttpException;
import org.smartboot.http.server.HttpRequestProtocol;
import org.smartboot.http.server.Request;
import org.smartboot.http.server.WebSocketRequestImpl;
import org.smartboot.http.server.decode.Decoder;
import org.smartboot.http.server.decode.HttpBodyDecoder;
import org.smartboot.http.utils.Attachment;
import org.smartboot.http.utils.StringUtils;
import org.smartboot.socket.transport.AioSession;

class HttpHeaderEndDecoder
implements Decoder {
    private final HttpBodyDecoder decoder = new HttpBodyDecoder();

    HttpHeaderEndDecoder() {
    }

    @Override
    public Decoder deocde(ByteBuffer byteBuffer, char[] cacheChars, AioSession aioSession, Request request) {
        if (request.isWebsocket() == null) {
            request.setWebsocket("websocket".equals(request.getHeader("Upgrade")) && "Upgrade".equals(request.getHeader("Connection")) ? YesNoEnum.Yes : YesNoEnum.NO);
        }
        if (HttpMethodEnum.GET.getMethod().equals(request.getMethod())) {
            if (request.isWebsocket() == YesNoEnum.Yes) {
                WebSocketRequestImpl webSocketRequest = new WebSocketRequestImpl(request);
                Attachment attachment = (Attachment)aioSession.getAttachment();
                attachment.put(HttpRequestProtocol.ATTACH_KEY_WS_REQ, webSocketRequest);
                return HttpRequestProtocol.WS_HANDSHARK_DECODER;
            }
            return HttpRequestProtocol.HTTP_FINISH_DECODER;
        }
        if (this.likePost(request.getMethod()) && StringUtils.startsWith(request.getContentType(), "application/x-www-form-urlencoded")) {
            int postLength = request.getContentLength();
            if (postLength > 0x200000) {
                throw new HttpException(HttpStatus.PAYLOAD_TOO_LARGE);
            }
            if (postLength <= 0) {
                throw new HttpException(HttpStatus.LENGTH_REQUIRED);
            }
            return this.decoder.deocde(byteBuffer, cacheChars, aioSession, request);
        }
        return HttpRequestProtocol.HTTP_FINISH_DECODER;
    }

    private boolean likePost(String method) {
        return HttpMethodEnum.POST.getMethod().equals(method) || HttpMethodEnum.PUT.getMethod().equals(method) || HttpMethodEnum.DELETE.getMethod().equals(method) || HttpMethodEnum.PATCH.getMethod().equals(method);
    }
}

