/*
 * Decompiled with CFR 0.152.
 */
package org.smartboot.http.utils;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.StringTokenizer;

public class StringUtils {
    public static final String[] EMPTY_STRING_ARRAY;
    public static final String EMPTY = "";
    public static final int INDEX_NOT_FOUND = -1;
    public static final List<StringCache>[] String_CACHE_URL;
    public static final List<StringCache>[] String_CACHE_HEADER_NAME;
    public static final List<StringCache>[] String_CACHE_HEADER_VALUE;

    public static String convertToString(char[] bytes, int length, List<StringCache>[] cacheList) {
        return StringUtils.convertToString(bytes, 0, length, cacheList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String convertToString(char[] bytes, int offset, int length, List<StringCache>[] cacheList) {
        if (length >= cacheList.length) {
            return new String(bytes, offset, length);
        }
        List<StringCache> list = cacheList[length];
        for (int i = list.size() - 1; i > -1; --i) {
            StringCache cache = list.get(i);
            if (!StringUtils.equals(cache.bytes, bytes, offset)) continue;
            return cache.value;
        }
        List<StringCache> list2 = list;
        synchronized (list2) {
            for (StringCache cache : list) {
                if (!StringUtils.equals(cache.bytes, bytes, offset)) continue;
                return cache.value;
            }
            String str = new String(bytes, offset, length);
            list.add(new StringCache(str.toCharArray(), str));
            return str;
        }
    }

    private static boolean equals(char[] b0, char[] b1, int offset) {
        for (int i = b0.length - 1; i > 0; --i) {
            if (b0[i] == b1[i + offset]) continue;
            return false;
        }
        return b0[0] == b1[offset];
    }

    public static boolean isEmpty(CharSequence cs) {
        return cs == null || cs.length() == 0;
    }

    public static boolean isBlank(CharSequence cs) {
        int strLen;
        if (cs == null || (strLen = cs.length()) == 0) {
            return true;
        }
        for (int i = 0; i < strLen; ++i) {
            if (Character.isWhitespace(cs.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isNotBlank(CharSequence cs) {
        return !StringUtils.isBlank(cs);
    }

    public static boolean equals(CharSequence cs1, CharSequence cs2) {
        if (cs1 == cs2) {
            return true;
        }
        if (cs1 == null || cs2 == null) {
            return false;
        }
        if (cs1 instanceof String && cs2 instanceof String) {
            return cs1.equals(cs2);
        }
        return StringUtils.regionMatches(cs1, false, 0, cs2, 0, Math.max(cs1.length(), cs2.length()));
    }

    private static boolean regionMatches(CharSequence cs, boolean ignoreCase, int thisStart, CharSequence substring, int start, int length) {
        if (cs instanceof String && substring instanceof String) {
            return ((String)cs).regionMatches(ignoreCase, thisStart, (String)substring, start, length);
        }
        int index1 = thisStart;
        int index2 = start;
        int tmpLen = length;
        while (tmpLen-- > 0) {
            char c2;
            char c1;
            if ((c1 = cs.charAt(index1++)) == (c2 = substring.charAt(index2++))) continue;
            if (!ignoreCase) {
                return false;
            }
            if (Character.toUpperCase(c1) == Character.toUpperCase(c2) || Character.toLowerCase(c1) == Character.toLowerCase(c2)) continue;
            return false;
        }
        return true;
    }

    public static int indexOf(CharSequence seq, CharSequence searchSeq, int startPos) {
        if (seq == null || searchSeq == null) {
            return -1;
        }
        return seq.toString().indexOf(searchSeq.toString(), startPos);
    }

    public static String substring(String str, int start) {
        if (str == null) {
            return null;
        }
        if (start < 0) {
            start = str.length() + start;
        }
        if (start < 0) {
            start = 0;
        }
        if (start > str.length()) {
            return EMPTY;
        }
        return str.substring(start);
    }

    public static String substring(String str, int start, int end) {
        if (str == null) {
            return null;
        }
        if (end < 0) {
            end = str.length() + end;
        }
        if (start < 0) {
            start = str.length() + start;
        }
        if (end > str.length()) {
            end = str.length();
        }
        if (start > end) {
            return EMPTY;
        }
        if (start < 0) {
            start = 0;
        }
        if (end < 0) {
            end = 0;
        }
        return str.substring(start, end);
    }

    public static String substringBefore(String str, String separator) {
        if (StringUtils.isEmpty(str) || separator == null) {
            return str;
        }
        if (separator.isEmpty()) {
            return EMPTY;
        }
        int pos = str.indexOf(separator);
        if (pos == -1) {
            return str;
        }
        return str.substring(0, pos);
    }

    public static String substringAfter(String str, String separator) {
        if (StringUtils.isEmpty(str)) {
            return str;
        }
        if (separator == null) {
            return EMPTY;
        }
        int pos = str.indexOf(separator);
        if (pos == -1) {
            return EMPTY;
        }
        return str.substring(pos + separator.length());
    }

    public static String[] split(String str, String separatorChars) {
        return StringUtils.splitWorker(str, separatorChars, -1, false);
    }

    public static String[] splitPreserveAllTokens(String str, String separatorChars) {
        return StringUtils.splitWorker(str, separatorChars, -1, true);
    }

    private static String[] splitWorker(String str, String separatorChars, int max, boolean preserveAllTokens) {
        if (str == null) {
            return null;
        }
        int len = str.length();
        if (len == 0) {
            return EMPTY_STRING_ARRAY;
        }
        ArrayList<String> list = new ArrayList<String>();
        int sizePlus1 = 1;
        int i = 0;
        int start = 0;
        boolean match = false;
        boolean lastMatch = false;
        if (separatorChars == null) {
            while (i < len) {
                if (Character.isWhitespace(str.charAt(i))) {
                    if (match || preserveAllTokens) {
                        lastMatch = true;
                        if (sizePlus1++ == max) {
                            i = len;
                            lastMatch = false;
                        }
                        list.add(str.substring(start, i));
                        match = false;
                    }
                    start = ++i;
                    continue;
                }
                lastMatch = false;
                match = true;
                ++i;
            }
        } else if (separatorChars.length() == 1) {
            char sep = separatorChars.charAt(0);
            while (i < len) {
                if (str.charAt(i) == sep) {
                    if (match || preserveAllTokens) {
                        lastMatch = true;
                        if (sizePlus1++ == max) {
                            i = len;
                            lastMatch = false;
                        }
                        list.add(str.substring(start, i));
                        match = false;
                    }
                    start = ++i;
                    continue;
                }
                lastMatch = false;
                match = true;
                ++i;
            }
        } else {
            while (i < len) {
                if (separatorChars.indexOf(str.charAt(i)) >= 0) {
                    if (match || preserveAllTokens) {
                        lastMatch = true;
                        if (sizePlus1++ == max) {
                            i = len;
                            lastMatch = false;
                        }
                        list.add(str.substring(start, i));
                        match = false;
                    }
                    start = ++i;
                    continue;
                }
                lastMatch = false;
                match = true;
                ++i;
            }
        }
        if (match || preserveAllTokens && lastMatch) {
            list.add(str.substring(start, i));
        }
        return list.toArray(new String[list.size()]);
    }

    public static boolean hasLength(CharSequence str) {
        return str != null && str.length() > 0;
    }

    public static boolean hasLength(String str) {
        return StringUtils.hasLength((CharSequence)str);
    }

    public static String[] tokenizeToStringArray(String str, String delimiters, boolean trimTokens, boolean ignoreEmptyTokens) {
        if (str == null) {
            return null;
        }
        StringTokenizer st = new StringTokenizer(str, delimiters);
        ArrayList<String> tokens = new ArrayList<String>();
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            if (trimTokens) {
                token = token.trim();
            }
            if (ignoreEmptyTokens && token.length() <= 0) continue;
            tokens.add(token);
        }
        return StringUtils.toStringArray(tokens);
    }

    public static String[] toStringArray(Collection<String> collection) {
        if (collection == null) {
            return null;
        }
        return collection.toArray(new String[collection.size()]);
    }

    public static int length(CharSequence cs) {
        return cs == null ? 0 : cs.length();
    }

    public static boolean startsWith(CharSequence str, CharSequence prefix) {
        return StringUtils.startsWith(str, prefix, false);
    }

    private static boolean startsWith(CharSequence str, CharSequence prefix, boolean ignoreCase) {
        if (str == null || prefix == null) {
            return str == null && prefix == null;
        }
        if (prefix.length() > str.length()) {
            return false;
        }
        return StringUtils.regionMatches(str, ignoreCase, 0, prefix, 0, prefix.length());
    }

    public static boolean endsWith(CharSequence str, CharSequence suffix) {
        return StringUtils.endsWith(str, suffix, false);
    }

    private static boolean endsWith(CharSequence str, CharSequence suffix, boolean ignoreCase) {
        if (str == null || suffix == null) {
            return str == null && suffix == null;
        }
        if (suffix.length() > str.length()) {
            return false;
        }
        int strOffset = str.length() - suffix.length();
        return StringUtils.regionMatches(str, ignoreCase, strOffset, suffix, 0, suffix.length());
    }

    public static int scanUntilAndTrim(ByteBuffer buffer, byte split, char[] cacheChars, int charsIndex, boolean trim) {
        buffer.mark();
        int i = 0;
        if (trim) {
            while ((cacheChars[charsIndex] = (char)(buffer.get() & 0xFF)) == ' ') {
            }
            i = 1;
        }
        while (buffer.hasRemaining()) {
            cacheChars[charsIndex + i] = (char)(buffer.get() & 0xFF);
            if (cacheChars[charsIndex + i] == split) {
                while (trim && cacheChars[charsIndex + i - 1] == ' ') {
                    --i;
                }
                return i;
            }
            ++i;
        }
        buffer.reset();
        return -1;
    }

    public static int scanUntilAndTrim(ByteBuffer buffer, byte split, char[] cacheChars, boolean trim) {
        return StringUtils.scanUntilAndTrim(buffer, split, cacheChars, 0, trim);
    }

    static {
        int i;
        EMPTY_STRING_ARRAY = new String[0];
        String_CACHE_URL = new List[512];
        String_CACHE_HEADER_NAME = new List[32];
        String_CACHE_HEADER_VALUE = new List[512];
        for (i = 0; i < String_CACHE_URL.length; ++i) {
            StringUtils.String_CACHE_URL[i] = new ArrayList<StringCache>(8);
        }
        for (i = 0; i < String_CACHE_HEADER_NAME.length; ++i) {
            StringUtils.String_CACHE_HEADER_NAME[i] = new ArrayList<StringCache>(8);
        }
        for (i = 0; i < String_CACHE_HEADER_VALUE.length; ++i) {
            StringUtils.String_CACHE_HEADER_VALUE[i] = new ArrayList<StringCache>(8);
        }
    }

    static class StringCache {
        final char[] bytes;
        final String value;

        public StringCache(char[] bytes, String value) {
            this.bytes = bytes;
            this.value = value;
        }
    }
}

