/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.boot.jetty;

import javax.servlet.annotation.WebFilter;
import javax.servlet.annotation.WebListener;
import javax.servlet.annotation.WebServlet;
import org.noear.solon.Solon;
import org.noear.solon.SolonApp;
import org.noear.solon.boot.ServerProps;
import org.noear.solon.boot.jetty.JettyServer;
import org.noear.solon.boot.jetty.JettyServerAddJsp;
import org.noear.solon.boot.jetty.JettyServerBase;
import org.noear.solon.boot.jetty.http.FormContentFilter;
import org.noear.solon.boot.prop.impl.HttpServerProps;
import org.noear.solon.core.AopContext;
import org.noear.solon.core.Plugin;
import org.noear.solon.core.Signal;
import org.noear.solon.core.SignalSim;
import org.noear.solon.core.SignalType;
import org.noear.solon.core.event.EventBus;
import org.noear.solon.core.handle.Handler;
import org.noear.solon.core.util.ClassUtil;
import org.noear.solon.core.util.LogUtil;

public final class XPluginImp
implements Plugin {
    private static Signal _signal;
    private JettyServerBase _server = null;

    public static Signal signal() {
        return _signal;
    }

    public static String solon_boot_ver() {
        return "jetty 9.4.51/" + Solon.version();
    }

    public void start(AopContext context) {
        if (!Solon.app().enableHttp()) {
            return;
        }
        context.beanBuilderAdd(WebFilter.class, (clz, bw, ano) -> {});
        context.beanBuilderAdd(WebServlet.class, (clz, bw, ano) -> {});
        context.beanBuilderAdd(WebListener.class, (clz, bw, ano) -> {});
        context.lifecycle(-99, () -> this.start0(Solon.app()));
    }

    private void start0(SolonApp app) throws Throwable {
        ServerProps.init();
        Class jspClz = ClassUtil.loadClass((String)"org.eclipse.jetty.jsp.JettyJspServlet");
        if (ServerProps.request_maxBodySize > 0L) {
            System.setProperty("org.eclipse.jetty.server.Request.maxFormContentSize", String.valueOf(ServerProps.request_maxBodySize));
        }
        this._server = jspClz == null ? new JettyServer() : new JettyServerAddJsp();
        HttpServerProps props = this._server.getProps();
        String _host = props.getHost();
        int _port = props.getPort();
        String _name = props.getName();
        long time_start = System.currentTimeMillis();
        EventBus.push((Object)this._server);
        this._server.start(_host, _port);
        String _wrapHost = props.getWrapHost();
        int _wrapPort = props.getWrapPort();
        _signal = new SignalSim(_name, _wrapHost, _wrapPort, "http", SignalType.HTTP);
        app.signalAdd(_signal);
        long time_end = System.currentTimeMillis();
        String connectorInfo = "Connector:main: jetty: Started ServerConnector@{HTTP/1.1,[http/1.1]";
        if (app.enableWebSocket()) {
            LogUtil.global().info(connectorInfo + "[WebSocket]}{0.0.0.0:" + _port + "}");
        }
        LogUtil.global().info(connectorInfo + "}{http://localhost:" + _port + "}");
        LogUtil.global().info("Server:main: jetty: Started (" + XPluginImp.solon_boot_ver() + ") @" + (time_end - time_start) + "ms");
        app.before(-9, (Handler)new FormContentFilter());
    }

    public void stop() throws Throwable {
        if (this._server != null) {
            this._server.stop();
            this._server = null;
            LogUtil.global().info("Server:main: jetty: Has Stopped (" + XPluginImp.solon_boot_ver() + ")");
        }
    }
}

