/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.boot.jetty;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.concurrent.ExecutorService;
import javax.servlet.ServletContext;
import org.eclipse.jetty.http.HttpVersion;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.SslConnectionFactory;
import org.eclipse.jetty.server.session.SessionHandler;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.util.component.LifeCycle;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.util.resource.ResourceCollection;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.noear.solon.Solon;
import org.noear.solon.Utils;
import org.noear.solon.boot.ServerLifecycle;
import org.noear.solon.boot.ServerProps;
import org.noear.solon.boot.jetty.http.JtContainerInitializer;
import org.noear.solon.boot.jetty.http.JtHttpContextHandler;
import org.noear.solon.boot.jetty.http.JtHttpContextServletHandler;
import org.noear.solon.boot.prop.impl.HttpServerProps;
import org.noear.solon.core.runtime.NativeDetector;
import org.noear.solon.core.util.ResourceUtil;

abstract class JettyServerBase
implements ServerLifecycle {
    protected ExecutorService executor;
    protected HttpServerProps props = new HttpServerProps();

    JettyServerBase() {
    }

    public HttpServerProps getProps() {
        return this.props;
    }

    public void setExecutor(ExecutorService executor) {
        this.executor = executor;
    }

    protected ServerConnector getConnector(Server server) throws RuntimeException {
        HttpConfiguration config = new HttpConfiguration();
        if (ServerProps.request_maxHeaderSize != 0) {
            config.setRequestHeaderSize(ServerProps.request_maxHeaderSize);
        }
        HttpConnectionFactory httpFactory = new HttpConnectionFactory(config);
        if (System.getProperty("javax.net.ssl.keyStore") == null) {
            return new ServerConnector(server, new ConnectionFactory[]{httpFactory});
        }
        String sslKeyStore = System.getProperty("javax.net.ssl.keyStore");
        String sslKeyStoreType = System.getProperty("javax.net.ssl.keyStoreType");
        String sslKeyStorePassword = System.getProperty("javax.net.ssl.keyStorePassword");
        SslContextFactory.Server contextFactory = new SslContextFactory.Server();
        if (Utils.isNotEmpty((String)sslKeyStore)) {
            URL url = ResourceUtil.getResource((String)sslKeyStore);
            if (url != null) {
                sslKeyStore = url.toString();
            }
            contextFactory.setKeyStorePath(sslKeyStore);
        }
        if (Utils.isNotEmpty((String)sslKeyStoreType)) {
            contextFactory.setKeyStoreType(sslKeyStoreType);
        }
        if (Utils.isNotEmpty((String)sslKeyStorePassword)) {
            contextFactory.setKeyStorePassword(sslKeyStorePassword);
        }
        SslConnectionFactory sslFactory = new SslConnectionFactory((SslContextFactory)contextFactory, HttpVersion.HTTP_1_1.asString());
        return new ServerConnector(server, new ConnectionFactory[]{sslFactory, httpFactory});
    }

    protected ServletContextHandler getServletHandler() throws IOException {
        ServletContextHandler handler = new ServletContextHandler();
        handler.setContextPath("/");
        handler.addServlet(JtHttpContextServletHandler.class, "/");
        handler.setBaseResource((Resource)new ResourceCollection(this.getResourceURLs()));
        if (Solon.app().enableSessionState()) {
            handler.setSessionHandler(new SessionHandler());
            if (ServerProps.session_timeout > 0) {
                handler.getSessionHandler().setMaxInactiveInterval(ServerProps.session_timeout);
            }
        }
        handler.addLifeCycleListener((LifeCycle.Listener)new JtContainerInitializer((ServletContext)handler.getServletContext()));
        return handler;
    }

    protected Handler getJettyHandler() {
        JtHttpContextHandler _handler = new JtHttpContextHandler();
        if (Solon.app().enableSessionState()) {
            SessionHandler s_handler = new SessionHandler();
            if (ServerProps.session_timeout > 0) {
                s_handler.setMaxInactiveInterval(ServerProps.session_timeout);
            }
            s_handler.setHandler((Handler)_handler);
            return s_handler;
        }
        return _handler;
    }

    protected String[] getResourceURLs() throws FileNotFoundException {
        URL rootURL = this.getRootPath();
        if (rootURL == null) {
            if (NativeDetector.inNativeImage()) {
                return new String[0];
            }
            throw new FileNotFoundException("Unable to find root");
        }
        String resURL = rootURL.toString();
        if (Solon.cfg().isDebugMode() && !resURL.startsWith("jar:")) {
            int endIndex = resURL.indexOf("target");
            String debugResURL = resURL.substring(0, endIndex) + "src/main/resources/";
            return new String[]{debugResURL, resURL};
        }
        return new String[]{resURL};
    }

    protected URL getRootPath() {
        URL root = ResourceUtil.getResource((String)"/");
        if (root != null) {
            return root;
        }
        try {
            URL temp = ResourceUtil.getResource((String)"");
            if (temp == null) {
                return null;
            }
            String path = temp.toString();
            if (!path.startsWith("jar:")) {
                return null;
            }
            int endIndex = path.indexOf("!");
            path = path.substring(0, endIndex + 1) + "/";
            return new URL(path);
        }
        catch (MalformedURLException e) {
            return null;
        }
    }
}

