/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.boot.jdkhttp;

import com.sun.net.httpserver.Headers;
import com.sun.net.httpserver.HttpExchange;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.noear.solon.Utils;
import org.noear.solon.boot.jdkhttp.MultipartUtil;
import org.noear.solon.boot.web.HeaderUtils;
import org.noear.solon.boot.web.RedirectUtils;
import org.noear.solon.boot.web.WebContextBase;
import org.noear.solon.core.NvMap;
import org.noear.solon.core.handle.Context;
import org.noear.solon.core.handle.ContextAsyncListener;
import org.noear.solon.core.handle.UploadedFile;
import org.noear.solon.core.util.IgnoreCaseMap;
import org.noear.solon.core.util.IoUtil;

public class JdkHttpContext
extends WebContextBase {
    private HttpExchange _exchange;
    private Map<String, Object> _parameters;
    private boolean _isAsync;
    private long _asyncTimeout = 30000L;
    private CompletableFuture<Object> _asyncFuture;
    private List<ContextAsyncListener> _asyncListeners = new ArrayList<ContextAsyncListener>();
    private boolean _loadMultipartFormData = false;
    private URI _uri;
    private String _url;
    private NvMap _paramMap;
    private Map<String, List<String>> _paramsMap;
    private NvMap _cookieMap;
    private NvMap _headerMap;
    private Map<String, List<String>> _headersMap;
    private ByteArrayOutputStream _outputStreamTmp;
    private int _status = 200;
    private boolean _allows_write = true;
    private boolean _headers_sent = false;

    protected boolean innerIsAsync() {
        return this._isAsync;
    }

    public JdkHttpContext(HttpExchange exchange) {
        this._exchange = exchange;
        this._parameters = (Map)this._exchange.getAttribute("parameters");
        this._filesMap = new HashMap();
    }

    private void loadMultipartFormData() throws IOException {
        if (this._loadMultipartFormData) {
            return;
        }
        this._loadMultipartFormData = true;
        if (this.isMultipartFormData()) {
            MultipartUtil.buildParamsAndFiles(this, this._filesMap);
        }
    }

    public Object request() {
        return this._exchange;
    }

    public String remoteIp() {
        return this._exchange.getRemoteAddress().getAddress().getHostAddress();
    }

    public int remotePort() {
        return this._exchange.getRemoteAddress().getPort();
    }

    public String method() {
        return this._exchange.getRequestMethod();
    }

    public String protocol() {
        return this._exchange.getProtocol();
    }

    public URI uri() {
        if (this._uri == null) {
            this._uri = URI.create(this.url());
        }
        return this._uri;
    }

    public boolean isSecure() {
        return "https".equals(this.uri().getScheme());
    }

    public String url() {
        if (this._url == null) {
            this._url = this._exchange.getRequestURI().toString();
            if (this._url != null) {
                int idx;
                if (this._url.startsWith("/")) {
                    String host = this.header("Host");
                    if (host == null) {
                        host = this.header(":authority");
                        String scheme = this.header(":scheme");
                        if (host == null) {
                            host = "localhost";
                        }
                        this._url = scheme != null ? "https://" + host + this._url : scheme + "://" + host + this._url;
                    } else {
                        this._url = "http://" + host + this._url;
                    }
                }
                if ((idx = this._url.indexOf("?")) > 0) {
                    this._url = this._url.substring(0, idx);
                }
            }
        }
        return this._url;
    }

    public long contentLength() {
        return HeaderUtils.getContentLengthLong((Context)this);
    }

    public String queryString() {
        return this._exchange.getRequestURI().getQuery();
    }

    public InputStream bodyAsStream() throws IOException {
        return this._exchange.getRequestBody();
    }

    public NvMap paramMap() {
        if (this._paramMap == null) {
            this._paramMap = new NvMap();
            try {
                if (this.autoMultipart()) {
                    this.loadMultipartFormData();
                }
                this._parameters.forEach((k, v) -> {
                    if (v instanceof List) {
                        this._paramMap.put(k, ((List)v).get(0));
                    } else {
                        this._paramMap.put(k, (Object)((String)v));
                    }
                });
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Throwable e) {
                throw new RuntimeException(e);
            }
        }
        return this._paramMap;
    }

    public Map<String, List<String>> paramsMap() {
        if (this._paramsMap == null) {
            this._paramsMap = new LinkedHashMap<String, List<String>>();
            try {
                if (this.autoMultipart()) {
                    this.loadMultipartFormData();
                }
                this._parameters.forEach((k, v) -> {
                    if (v instanceof List) {
                        this._paramsMap.put((String)k, (List)v);
                    } else {
                        ArrayList<String> list = new ArrayList<String>();
                        list.add((String)v);
                        this._paramsMap.put((String)k, (List<String>)list);
                    }
                });
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
        }
        return this._paramsMap;
    }

    public Map<String, List<UploadedFile>> filesMap() throws IOException {
        if (this.isMultipartFormData()) {
            this.loadMultipartFormData();
            return this._filesMap;
        }
        return Collections.emptyMap();
    }

    public NvMap cookieMap() {
        if (this._cookieMap == null) {
            String[] ss;
            this._cookieMap = new NvMap();
            String tmp = this.headerOrDefault("Cookie", "");
            for (String s : ss = tmp.split(";")) {
                String[] kv = s.split("=");
                if (kv.length > 1) {
                    this._cookieMap.put(kv[0].trim(), (Object)kv[1].trim());
                    continue;
                }
                this._cookieMap.put(kv[0].trim(), null);
            }
        }
        return this._cookieMap;
    }

    public NvMap headerMap() {
        if (this._headerMap == null) {
            this.resolveHeaders();
        }
        return this._headerMap;
    }

    private void resolveHeaders() {
        this._headerMap = new NvMap();
        this._headersMap = new IgnoreCaseMap();
        Headers headers = this._exchange.getRequestHeaders();
        if (headers != null) {
            headers.forEach((k, l) -> {
                if (l.size() > 0) {
                    this._headerMap.put(k, l.get(0));
                }
                this._headersMap.put((String)k, (List<String>)l);
            });
        }
    }

    public Map<String, List<String>> headersMap() {
        if (this._headersMap == null) {
            this.resolveHeaders();
        }
        return this._headersMap;
    }

    public Object response() {
        return this._exchange;
    }

    protected void contentTypeDoSet(String contentType) {
        if (this.charset != null && contentType.indexOf(";") < 0) {
            this.headerSet("Content-Type", contentType + ";charset=" + this.charset);
            return;
        }
        this.headerSet("Content-Type", contentType);
    }

    public OutputStream outputStream() throws IOException {
        this.sendHeaders(false);
        if (this._allows_write) {
            return this._exchange.getResponseBody();
        }
        if (this._outputStreamTmp == null) {
            this._outputStreamTmp = new ByteArrayOutputStream();
        } else {
            this._outputStreamTmp.reset();
        }
        return this._outputStreamTmp;
    }

    public void output(byte[] bytes) {
        try {
            OutputStream out = this.outputStream();
            if (!this._allows_write) {
                return;
            }
            out.write(bytes);
        }
        catch (Throwable ex) {
            throw new RuntimeException(ex);
        }
    }

    public void output(InputStream stream) {
        try {
            OutputStream out = this.outputStream();
            if (!this._allows_write) {
                return;
            }
            IoUtil.transferTo((InputStream)stream, (OutputStream)out);
        }
        catch (Throwable ex) {
            throw new RuntimeException(ex);
        }
    }

    public void headerSet(String key, String val) {
        this._exchange.getResponseHeaders().set(key, val);
    }

    public void headerAdd(String key, String val) {
        this._exchange.getResponseHeaders().add(key, val);
    }

    public String headerOfResponse(String name) {
        return this._exchange.getResponseHeaders().getFirst(name);
    }

    public void cookieSet(String key, String val, String domain, String path, int maxAge) {
        StringBuilder sb = new StringBuilder();
        sb.append(key).append("=").append(val).append(";");
        if (Utils.isNotEmpty((String)path)) {
            sb.append("path=").append(path).append(";");
        }
        if (maxAge >= 0) {
            sb.append("max-age=").append(maxAge).append(";");
        }
        if (Utils.isNotEmpty((String)domain)) {
            sb.append("domain=").append(domain.toLowerCase()).append(";");
        }
        this.headerAdd("Set-Cookie", sb.toString());
    }

    public void redirect(String url, int code) {
        url = RedirectUtils.getRedirectPath((String)url);
        this.headerSet("Location", url);
        this.statusDoSet(code);
    }

    public int status() {
        return this._status;
    }

    protected void statusDoSet(int status) {
        this._status = status;
    }

    public void flush() throws IOException {
        if (this._allows_write) {
            this.outputStream().flush();
        }
    }

    public void close() throws IOException {
        this._exchange.close();
    }

    public boolean asyncSupported() {
        return true;
    }

    public void asyncStart(long timeout, ContextAsyncListener listener) {
        if (!this._isAsync) {
            this._isAsync = true;
            this._asyncFuture = new CompletableFuture();
            if (listener != null) {
                this._asyncListeners.add(listener);
            }
            if (timeout != 0L) {
                this._asyncTimeout = timeout;
            }
        }
    }

    public void asyncComplete() throws IOException {
        if (this._isAsync) {
            try {
                this.innerCommit();
            }
            finally {
                this._asyncFuture.complete((Object)this);
            }
        }
    }

    protected void asyncAwait() throws InterruptedException, ExecutionException, IOException {
        if (this._isAsync) {
            if (this._asyncTimeout > 0L) {
                try {
                    this._asyncFuture.get(this._asyncTimeout, TimeUnit.MILLISECONDS);
                }
                catch (Exception e) {
                    for (ContextAsyncListener listener1 : this._asyncListeners) {
                        listener1.onTimeout((Context)this);
                    }
                }
            } else {
                this._asyncFuture.get();
            }
        }
    }

    protected void innerCommit() throws IOException {
        if (this.getHandled() || this.status() >= 200) {
            this.sendHeaders(true);
        } else {
            this.status(404);
            this.sendHeaders(true);
        }
    }

    private void sendHeaders(boolean isCommit) throws IOException {
        if (!this._headers_sent) {
            this._headers_sent = true;
            if ("HEAD".equals(this.method())) {
                this._allows_write = false;
            }
            if (this.sessionState() != null) {
                this.sessionState().sessionPublish();
            }
            if (isCommit || !this._allows_write) {
                this._exchange.sendResponseHeaders(this.status(), -1L);
            } else {
                Object tmp = this._exchange.getResponseHeaders().get("Content-Length");
                if (tmp != null && tmp.size() > 0) {
                    this._exchange.sendResponseHeaders(this.status(), Long.parseLong((String)tmp.get(0)));
                } else {
                    this._exchange.sendResponseHeaders(this.status(), 0L);
                }
            }
        }
    }
}

