/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.boot.jdkhttp;

import com.sun.net.httpserver.HttpContext;
import com.sun.net.httpserver.HttpServer;
import com.sun.net.httpserver.HttpsConfigurator;
import com.sun.net.httpserver.HttpsParameters;
import com.sun.net.httpserver.HttpsServer;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.concurrent.Executor;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLParameters;
import org.noear.solon.Utils;
import org.noear.solon.boot.ServerLifecycle;
import org.noear.solon.boot.jdkhttp.JdkHttpContextHandler;
import org.noear.solon.boot.jdkhttp.ParameterFilter;
import org.noear.solon.boot.prop.ServerSslProps;
import org.noear.solon.boot.ssl.SslContextFactory;
import org.noear.solon.core.event.EventBus;
import org.noear.solon.core.handle.Handler;

public class JdkHttpServer
implements ServerLifecycle {
    private HttpServer server = null;
    private Executor executor;
    private Handler handler;
    private boolean enableSsl = true;
    private boolean isSecure;
    private ServerSslProps sslProps;

    public boolean isSecure() {
        return this.isSecure;
    }

    protected boolean supportSsl() {
        if (this.sslProps == null) {
            this.sslProps = ServerSslProps.of((String)"http");
        }
        return this.sslProps.isEnable() && this.sslProps.getSslKeyStore() != null;
    }

    public void enableSsl(boolean enable) {
        this.enableSsl = enable;
    }

    public void setHandler(Handler handler) {
        this.handler = handler;
    }

    public void setExecutor(Executor executor) {
        this.executor = executor;
    }

    public void start(String host, int port) throws Throwable {
        if (this.enableSsl && this.supportSsl()) {
            this.server = Utils.isNotEmpty((String)host) ? HttpsServer.create(new InetSocketAddress(host, port), 0) : HttpsServer.create(new InetSocketAddress(port), 0);
            this.addSslConfig((HttpsServer)this.server);
            this.isSecure = true;
        } else {
            this.server = Utils.isNotEmpty((String)host) ? HttpServer.create(new InetSocketAddress(host, port), 0) : HttpServer.create(new InetSocketAddress(port), 0);
        }
        HttpContext httpContext = this.server.createContext("/", new JdkHttpContextHandler(this.handler));
        httpContext.getFilters().add(new ParameterFilter());
        this.server.setExecutor(this.executor);
        this.server.start();
    }

    public void stop() throws Throwable {
        if (this.server != null) {
            this.server.stop(0);
            this.server = null;
        }
    }

    private void addSslConfig(HttpsServer httpsServer) throws IOException {
        SSLContext sslContext = SslContextFactory.create((ServerSslProps)this.sslProps);
        httpsServer.setHttpsConfigurator(new HttpsConfigurator(sslContext){

            @Override
            public void configure(HttpsParameters params) {
                try {
                    SSLContext c = SSLContext.getDefault();
                    SSLEngine engine = c.createSSLEngine();
                    params.setNeedClientAuth(false);
                    params.setCipherSuites(engine.getEnabledCipherSuites());
                    params.setProtocols(engine.getEnabledProtocols());
                    SSLParameters defaultSSLParameters = c.getDefaultSSLParameters();
                    params.setSSLParameters(defaultSSLParameters);
                }
                catch (Throwable e) {
                    EventBus.pushTry((Object)e);
                }
            }
        });
    }
}

