/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.boot.jdkhttp;

import com.sun.net.httpserver.HttpContext;
import com.sun.net.httpserver.HttpServer;
import com.sun.net.httpserver.HttpsConfigurator;
import com.sun.net.httpserver.HttpsParameters;
import com.sun.net.httpserver.HttpsServer;
import java.io.IOException;
import java.net.InetSocketAddress;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLParameters;
import org.noear.solon.Solon;
import org.noear.solon.SolonApp;
import org.noear.solon.Utils;
import org.noear.solon.boot.ServerProps;
import org.noear.solon.boot.jdkhttp.JdkHttpContextHandler;
import org.noear.solon.boot.jdkhttp.ParameterFilter;
import org.noear.solon.boot.prop.impl.HttpServerProps;
import org.noear.solon.boot.ssl.SslContextFactory;
import org.noear.solon.core.AopContext;
import org.noear.solon.core.Plugin;
import org.noear.solon.core.Signal;
import org.noear.solon.core.SignalSim;
import org.noear.solon.core.SignalType;
import org.noear.solon.core.event.EventBus;
import org.noear.solon.core.util.LogUtil;

public final class XPluginImp
implements Plugin {
    private static Signal _signal;
    private HttpServer _server = null;

    public static Signal signal() {
        return _signal;
    }

    public static String solon_boot_ver() {
        return "jdk http/" + Solon.version();
    }

    public void start(AopContext context) {
        if (!Solon.app().enableHttp()) {
            return;
        }
        if (Utils.loadClass((String)"org.noear.solon.boot.jetty.XPluginImp") != null) {
            return;
        }
        if (Utils.loadClass((String)"org.noear.solon.boot.undertow.XPluginImp") != null) {
            return;
        }
        if (Utils.loadClass((String)"org.noear.solon.boot.smarthttp.XPluginImp") != null) {
            return;
        }
        context.beanOnloaded(ctx -> {
            try {
                this.start0(Solon.app());
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Throwable e) {
                throw new IllegalStateException(e);
            }
        });
    }

    private void start0(SolonApp app) throws Throwable {
        ServerProps.init();
        HttpServerProps props = new HttpServerProps();
        String _host = props.getHost();
        int _port = props.getPort();
        String _name = props.getName();
        long time_start = System.currentTimeMillis();
        LogUtil.global().info("Server:main: Sun.net.HttpServer(jdkhttp)");
        if (System.getProperty("javax.net.ssl.keyStore") != null) {
            this._server = Utils.isNotEmpty((String)_host) ? HttpsServer.create(new InetSocketAddress(_host, _port), 0) : HttpsServer.create(new InetSocketAddress(_port), 0);
            this.addSslConfig((HttpsServer)this._server);
        } else {
            this._server = Utils.isNotEmpty((String)_host) ? HttpServer.create(new InetSocketAddress(_host, _port), 0) : HttpServer.create(new InetSocketAddress(_port), 0);
        }
        HttpContext httpContext = this._server.createContext("/", new JdkHttpContextHandler());
        httpContext.getFilters().add(new ParameterFilter());
        this._server.setExecutor(props.getBioExecutor("jdkhttp-"));
        this._server.start();
        String _wrapHost = props.getWrapHost();
        int _wrapPort = props.getWrapPort();
        _signal = new SignalSim(_name, _wrapHost, _wrapPort, "http", SignalType.HTTP);
        app.signalAdd(_signal);
        long time_end = System.currentTimeMillis();
        LogUtil.global().info("Connector:main: jdkhttp: Started ServerConnector@{HTTP/1.1,[http/1.1]}{http://localhost:" + _port + "}");
        LogUtil.global().info("Server:main: jdkhttp: Started @" + (time_end - time_start) + "ms");
    }

    private void addSslConfig(HttpsServer httpsServer) throws IOException {
        SSLContext sslContext = SslContextFactory.create();
        httpsServer.setHttpsConfigurator(new HttpsConfigurator(sslContext){

            @Override
            public void configure(HttpsParameters params) {
                try {
                    SSLContext c = SSLContext.getDefault();
                    SSLEngine engine = c.createSSLEngine();
                    params.setNeedClientAuth(false);
                    params.setCipherSuites(engine.getEnabledCipherSuites());
                    params.setProtocols(engine.getEnabledProtocols());
                    SSLParameters defaultSSLParameters = c.getDefaultSSLParameters();
                    params.setSSLParameters(defaultSSLParameters);
                }
                catch (Throwable e) {
                    EventBus.push((Object)e);
                }
            }
        });
    }

    public void stop() throws Throwable {
        if (this._server == null) {
            return;
        }
        this._server.stop(0);
        this._server = null;
        LogUtil.global().info("Server:main: jdkhttp: Has Stopped " + XPluginImp.solon_boot_ver());
    }
}

