/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.auth.impl;

import java.util.ArrayList;
import java.util.List;
import org.noear.solon.auth.AuthFailureHandler;
import org.noear.solon.auth.AuthRule;
import org.noear.solon.auth.AuthStatus;
import org.noear.solon.auth.AuthUtil;
import org.noear.solon.core.handle.Context;
import org.noear.solon.core.handle.Result;
import org.noear.solon.core.util.PathAnalyzer;

public class AuthRuleImpl
implements AuthRule {
    private List<PathAnalyzer> includeList = new ArrayList<PathAnalyzer>();
    private List<PathAnalyzer> excludeList = new ArrayList<PathAnalyzer>();
    private boolean verifyIp;
    private boolean verifyLogined;
    private boolean verifyPath;
    private String[] verifyPermissions;
    private boolean verifyPermissionsAnd;
    private String[] verifyRoles;
    private boolean verifyRolesAnd;
    private AuthFailureHandler failureHandler;

    @Override
    public AuthRule include(String pattern) {
        this.includeList.add(PathAnalyzer.get((String)pattern));
        return this;
    }

    @Override
    public AuthRule exclude(String pattern) {
        this.excludeList.add(PathAnalyzer.get((String)pattern));
        return this;
    }

    @Override
    public AuthRule verifyIp() {
        this.verifyIp = true;
        return this;
    }

    @Override
    public AuthRule verifyLogined() {
        this.verifyLogined = true;
        return this;
    }

    @Override
    public AuthRule verifyPath() {
        this.verifyPath = true;
        this.verifyLogined = true;
        return this;
    }

    @Override
    public AuthRule verifyPermissions(String ... permissions) {
        this.verifyPermissions = permissions;
        this.verifyPermissionsAnd = false;
        this.verifyLogined = true;
        return this;
    }

    @Override
    public AuthRule verifyPermissionsAnd(String ... permissions) {
        this.verifyPermissions = permissions;
        this.verifyPermissionsAnd = true;
        this.verifyLogined = true;
        return this;
    }

    @Override
    public AuthRule verifyRoles(String ... roles) {
        this.verifyRoles = roles;
        this.verifyRolesAnd = false;
        this.verifyLogined = true;
        return this;
    }

    @Override
    public AuthRule verifyRolesAnd(String ... roles) {
        this.verifyRoles = roles;
        this.verifyRolesAnd = true;
        this.verifyLogined = true;
        return this;
    }

    @Override
    public AuthRule failure(AuthFailureHandler handler) {
        this.failureHandler = handler;
        return this;
    }

    public boolean test(String path) {
        for (PathAnalyzer pa : this.excludeList) {
            if (!pa.matches(path)) continue;
            return false;
        }
        for (PathAnalyzer pa : this.includeList) {
            if (!pa.matches(path)) continue;
            return true;
        }
        return this.excludeList.size() > 0 && this.includeList.size() == 0;
    }

    public void handle(Context ctx) throws Throwable {
        String ip;
        String path = ctx.pathNew().toLowerCase();
        if (!this.test(path)) {
            return;
        }
        if (this.verifyIp && !AuthUtil.verifyIp(ip = ctx.realIp())) {
            this.failureDo(ctx, AuthStatus.OF_IP.toResult(ip));
            return;
        }
        if (this.verifyLogined && !AuthUtil.verifyLogined()) {
            if (AuthUtil.adapter().loginUrl() == null) {
                this.failureDo(ctx, AuthStatus.OF_LOGINED.toResult());
            } else {
                ctx.redirect(AuthUtil.adapter().loginUrl());
                ctx.setHandled(true);
            }
            return;
        }
        if (this.verifyPath && !AuthUtil.verifyPath(path, ctx.method())) {
            this.failureDo(ctx, AuthStatus.OF_PATH.toResult());
            return;
        }
        if (this.verifyPermissions != null && this.verifyPermissions.length > 0) {
            boolean isOk = false;
            isOk = this.verifyPermissionsAnd ? AuthUtil.verifyPermissionsAnd(this.verifyPermissions) : AuthUtil.verifyPermissions(this.verifyPermissions);
            if (!isOk) {
                this.failureDo(ctx, AuthStatus.OF_PERMISSIONS.toResult());
                return;
            }
        }
        if (this.verifyRoles != null && this.verifyRoles.length > 0) {
            boolean isOk = false;
            isOk = this.verifyRolesAnd ? AuthUtil.verifyRolesAnd(this.verifyRoles) : AuthUtil.verifyRoles(this.verifyRoles);
            if (!isOk) {
                this.failureDo(ctx, AuthStatus.OF_ROLES.toResult());
                return;
            }
        }
    }

    private void failureDo(Context c, Result r) throws Throwable {
        c.setHandled(true);
        if (this.failureHandler != null) {
            this.failureHandler.onFailure(c, r);
        } else {
            AuthUtil.adapter().failure().onFailure(c, r);
        }
    }
}

