/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.aot;

import java.io.File;
import java.io.FileWriter;
import java.lang.reflect.Method;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Pattern;
import org.noear.snack.ONode;
import org.noear.snack.core.Feature;
import org.noear.snack.core.Options;
import org.noear.solon.Solon;
import org.noear.solon.Utils;
import org.noear.solon.aot.AppContextNativeProcessor;
import org.noear.solon.aot.AppContextNativeProcessorDefault;
import org.noear.solon.aot.RuntimeNativeMetadata;
import org.noear.solon.aot.RuntimeNativeRegistrar;
import org.noear.solon.aot.Settings;
import org.noear.solon.aot.graalvm.GraalvmUtil;
import org.noear.solon.aot.hint.ResourceHint;
import org.noear.solon.core.AppContext;
import org.noear.solon.core.PluginEntity;
import org.noear.solon.core.util.ClassUtil;
import org.noear.solon.core.util.LogUtil;
import org.noear.solon.core.util.ScanUtil;

public class SolonAotProcessor {
    private final Options jsonOptions = Options.def().add(new Feature[]{Feature.PrettyFormat}).add(new Feature[]{Feature.OrderedField});
    private final Settings settings;
    private final String[] applicationArgs;
    private final Class<?> applicationClass;

    public SolonAotProcessor(Settings settings, String[] applicationArgs, Class<?> applicationClass) {
        this.settings = settings;
        this.applicationArgs = applicationArgs;
        this.applicationClass = applicationClass;
    }

    public static void main(String[] args) throws Exception {
        LogUtil.global().info("Aot processor start, args: " + Arrays.toString(args));
        int requiredArgs = 5;
        if (args.length < requiredArgs) {
            throw new IllegalArgumentException("Usage: " + SolonAotProcessor.class.getName() + " <applicationName> <classOutput> <generatedSources> <groupId> <artifactId> <originalArgs...>");
        }
        Class<?> application = Class.forName(args[0]);
        Settings build = new Settings(Paths.get(args[1], new String[0]), Paths.get(args[2], new String[0]), args[3], args[4]);
        String[] applicationArgs = args.length > requiredArgs ? Arrays.copyOfRange(args, requiredArgs, args.length) : new String[]{};
        new SolonAotProcessor(build, applicationArgs, application).process();
    }

    public final void process() {
        try {
            System.setProperty("solon.aot.processing", "true");
            this.doProcess();
        }
        finally {
            System.clearProperty("solon.aot.processing");
        }
    }

    protected void doProcess() {
        try {
            Method mainMethod = this.applicationClass.getMethod("main", String[].class);
            mainMethod.invoke(null, new Object[]{this.applicationArgs});
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        AppContext context = Solon.context();
        AppContextNativeProcessor contextNativeProcessor = (AppContextNativeProcessor)context.getBean(AppContextNativeProcessor.class);
        if (contextNativeProcessor == null) {
            contextNativeProcessor = new AppContextNativeProcessorDefault();
        }
        RuntimeNativeMetadata metadata = new RuntimeNativeMetadata();
        metadata.setApplicationClassName(this.applicationClass.getCanonicalName());
        contextNativeProcessor.process(context, this.settings, metadata);
        List plugs = Solon.cfg().plugs();
        for (PluginEntity plug : plugs) {
            if (!Utils.isNotEmpty((String)plug.getClassName())) continue;
            metadata.registerDefaultConstructor(plug.getClassName());
        }
        List runtimeNativeRegistrars = context.getBeansOfType(RuntimeNativeRegistrar.class);
        for (RuntimeNativeRegistrar runtimeNativeRegistrar : runtimeNativeRegistrars) {
            runtimeNativeRegistrar.register(context, metadata);
        }
        this.addNativeImage(metadata);
        this.addResourceConfig(metadata);
        this.addReflectConfig(metadata);
        this.addSerializationConfig(metadata);
        this.addJdkProxyConfig(metadata);
        LogUtil.global().info("Aot processor end.");
        Solon.stopBlock((boolean)true, (int)-1, (int)0);
    }

    private void addSerializationConfig(RuntimeNativeMetadata metadata) {
        String serializationJson = metadata.toSerializationJson();
        if (Utils.isEmpty((String)serializationJson)) {
            return;
        }
        try {
            FileWriter fileWriter = this.getFileWriter("serialization-config.json");
            fileWriter.write(serializationJson);
            fileWriter.close();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void addJdkProxyConfig(RuntimeNativeMetadata metadata) {
        String jdkProxyJson = metadata.toJdkProxyJson();
        if (Utils.isEmpty((String)jdkProxyJson)) {
            return;
        }
        try {
            FileWriter fileWriter = this.getFileWriter("proxy-config.json");
            fileWriter.write(jdkProxyJson);
            fileWriter.close();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void addNativeImage(RuntimeNativeMetadata metadata) {
        try {
            Set<String> args = this.getDefaultNativeImageArguments(metadata.getApplicationClassName());
            args.addAll(metadata.getArgs());
            StringBuilder sb = new StringBuilder();
            sb.append("Args = ");
            sb.append(String.join((CharSequence)String.format(" \\%n", new Object[0]), args));
            FileWriter fileWriter = this.getFileWriter("native-image.properties");
            fileWriter.write(sb.toString());
            fileWriter.close();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void addResourceConfig(RuntimeNativeMetadata metadata) {
        try {
            metadata.registerResourceInclude("app.*\\.yml").registerResourceInclude("app.*\\.properties").registerResourceInclude("META-INF/.*").registerResourceInclude("WEB-INF/.*").registerResourceInclude("static/.*").registerResourceInclude("templates/.*");
            List<ResourceHint> includes = metadata.getIncludes();
            ArrayList<String> allResources = new ArrayList<String>();
            for (ResourceHint include : includes) {
                Pattern pattern;
                Set scanned;
                String pathDir;
                int pathIdx = include.getPattern().indexOf("/");
                if (pathIdx <= 0 || (pathDir = include.getPattern().substring(0, pathIdx)).contains("*") || (scanned = ScanUtil.scan((String)pathDir, arg_0 -> SolonAotProcessor.lambda$addResourceConfig$0(pattern = Pattern.compile(include.getPattern().substring(pathIdx + 1)), arg_0))).isEmpty()) continue;
                for (String uri : scanned) {
                    if (uri.startsWith("META-INF/maven/")) continue;
                    allResources.add(uri);
                }
            }
            FileWriter solonResourceFile = this.getFileWriter("solon-resource.json");
            solonResourceFile.write(ONode.load(allResources, (Options)this.jsonOptions).toJson());
            solonResourceFile.close();
            FileWriter fileWriter = this.getFileWriter("resource-config.json");
            fileWriter.write(metadata.toResourcesJson());
            fileWriter.close();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void addReflectConfig(RuntimeNativeMetadata metadata) {
        try {
            this.addReflectConfigDo(metadata, "org.noear.solon.extend.impl.PropsLoaderExt");
            this.addReflectConfigDo(metadata, "org.noear.solon.extend.impl.PropsConverterExt");
            this.addReflectConfigDo(metadata, "org.noear.solon.extend.impl.AppClassLoaderExt");
            this.addReflectConfigDo(metadata, "org.noear.solon.extend.impl.ReflectionExt");
            this.addReflectConfigDo(metadata, "org.noear.solon.extend.impl.ResourceScannerExt");
            this.addReflectConfigDo(metadata, "org.noear.solon.extend.impl.LogUtilExt");
            this.addReflectConfigDo(metadata, "org.noear.solon.extend.impl.ProxyBinderExt");
            FileWriter fileWriter = this.getFileWriter("reflect-config.json");
            fileWriter.write(metadata.toReflectionJson());
            fileWriter.close();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void addReflectConfigDo(RuntimeNativeMetadata metadata, String className) {
        if (ClassUtil.loadClass((String)className) != null) {
            metadata.registerDefaultConstructor(className);
        }
    }

    private Set<String> getDefaultNativeImageArguments(String applicationClassName) {
        TreeSet<String> args = new TreeSet<String>();
        args.add("-H:Class=" + applicationClassName);
        args.add("--report-unsupported-elements-at-runtime");
        args.add("--no-fallback");
        args.add("--install-exit-handlers");
        return args;
    }

    private FileWriter getFileWriter(String configName) {
        try {
            boolean newFile;
            String dir = GraalvmUtil.getNativeImageDir();
            String fileName = String.join((CharSequence)"/", dir, configName);
            File file = new File(this.settings.getClassOutput() + "/" + fileName);
            File parentFile = file.getParentFile();
            if (!parentFile.exists()) {
                parentFile.mkdirs();
            }
            if (newFile = file.createNewFile()) {
                LogUtil.global().info("create file: " + file.getAbsolutePath());
            }
            return new FileWriter(file);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private boolean isEmpty(Object[] objects) {
        return objects == null || objects.length == 0;
    }

    private boolean isNotEmpty(Object[] objects) {
        return !this.isEmpty(objects);
    }

    private static /* synthetic */ boolean lambda$addResourceConfig$0(Pattern pattern, String path) {
        return pattern.matcher(path).find();
    }
}

