/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.web.staticfiles;

import org.noear.solon.Solon;
import org.noear.solon.Utils;

public class StaticConfig {
    public static final String PROP_ENABLE = "solon.staticfiles.enable";
    public static final String PROP_CACHE_MAX_AGE = "solon.staticfiles.cacheMaxAge";
    public static final String PROP_MAPPINGS = "solon.staticfiles.mappings";
    public static final String RES_STATIC_LOCATION = "static/";
    public static final String RES_WEB_INF_STATIC_LOCATION = "WEB-INF/static/";
    private static int cacheMaxAge;

    public static int getCacheMaxAge() {
        return cacheMaxAge;
    }

    public static void setCacheMaxAge(int maxAge) {
        cacheMaxAge = maxAge;
    }

    public static boolean isEnable() {
        return Solon.cfg().getBool(PROP_ENABLE, true);
    }

    static {
        if (Solon.cfg().isDebugMode()) {
            cacheMaxAge = -1;
        } else {
            String tmp = Solon.cfg().get(PROP_CACHE_MAX_AGE);
            if (Utils.isEmpty((String)tmp)) {
                tmp = Solon.cfg().get("solon.staticfiles.maxAge");
            }
            if (Utils.isEmpty((String)tmp)) {
                tmp = "600";
            }
            cacheMaxAge = Integer.parseInt(tmp);
        }
    }
}

