/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.web.servlet;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import javax.servlet.MultipartConfigElement;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import javax.servlet.ServletRegistration;
import org.noear.solon.Solon;
import org.noear.solon.Utils;
import org.noear.solon.core.event.AppInitEndEvent;
import org.noear.solon.core.event.AppLoadEndEvent;
import org.noear.solon.core.event.EventBus;
import org.noear.solon.core.handle.ContextPathFilter;
import org.noear.solon.core.handle.Filter;
import org.noear.solon.core.util.ClassUtil;
import org.noear.solon.core.util.IoUtil;
import org.noear.solon.server.ServerProps;
import org.noear.solon.web.servlet.SolonServletHandler;
import org.noear.solon.web.servlet.SolonWebSocketEndpoint;

public class SolonServletContextListener
implements ServletContextListener {
    public void contextInitialized(ServletContextEvent sce) {
        EventBus.subscribe(AppInitEndEvent.class, e -> {
            Solon.app().enableHttp(false);
            Solon.cfg().isFilesMode(false);
            String contextPath = sce.getServletContext().getContextPath();
            if (contextPath.length() > 1) {
                Solon.app().filterIfAbsent(-990, (Filter)new ContextPathFilter(contextPath, false));
            }
        });
        EventBus.subscribe(AppLoadEndEvent.class, e -> {
            ServletRegistration.Dynamic registration = sce.getServletContext().addServlet("solon", SolonServletHandler.class);
            if (registration != null) {
                registration.addMapping(new String[]{"/*"});
                String _tempdir = IoUtil.getTempDirAsString((String)"solon-server");
                MultipartConfigElement configElement = new MultipartConfigElement(_tempdir, ServerProps.request_maxFileSize, ServerProps.request_maxFileRequestSize(), ServerProps.request_fileSizeThreshold);
                registration.setMultipartConfig(configElement);
            }
            if (e.app().enableWebSocket()) {
                SolonWebSocketEndpoint.addEndpoint(sce.getServletContext());
            }
        });
        this.invokeMain(sce.getServletContext(), new String[0]);
    }

    private void invokeMain(ServletContext sc, String[] strArgs) throws RuntimeException {
        Class mainClass = this.getClass();
        String mainClassStr = sc.getInitParameter("solonMainClass");
        if (Utils.isEmpty((String)mainClassStr)) {
            mainClassStr = sc.getInitParameter("solonStartClass");
        }
        if (Utils.isNotEmpty((String)mainClassStr) && (mainClass = ClassUtil.loadClass((String)mainClassStr)) == null) {
            throw new IllegalStateException("The start class was not found: '" + mainClassStr + "'");
        }
        Method mainMethod = null;
        try {
            mainMethod = mainClass.getMethod("main", String[].class);
        }
        catch (Exception ex) {
            mainMethod = null;
        }
        if (mainMethod != null && Modifier.isStatic(mainMethod.getModifiers())) {
            try {
                mainMethod.invoke(null, new Object[]{strArgs});
            }
            catch (Throwable e) {
                if (e instanceof RuntimeException) {
                    throw (RuntimeException)e;
                }
                throw new IllegalStateException(e);
            }
        } else {
            throw new IllegalStateException("The main function was not found for: " + this.getClass().getName());
        }
    }

    public void contextDestroyed(ServletContextEvent sce) {
        if (Solon.cfg().stopSafe()) {
            Solon.stopBlock((boolean)false, (int)Solon.cfg().stopDelay());
        } else {
            Solon.stopBlock((boolean)false, (int)0);
        }
    }
}

