/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.boot.http;

import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import org.noear.solon.core.util.IoUtil;
import org.noear.solon.server.ServerProps;

@Deprecated
public class HttpPartFile {
    private File tempfile;
    private InputStream content;
    private final long size;
    private final String filename;

    public HttpPartFile(String filename, InputStream ins) throws IOException {
        this.filename = filename;
        ByteArrayOutputStream thresholdBuffer = new ByteArrayOutputStream();
        if (ServerProps.request_fileSizeThreshold > 0) {
            IoUtil.transferTo((InputStream)ins, (OutputStream)thresholdBuffer, (long)0L, (long)ServerProps.request_fileSizeThreshold);
        }
        if (thresholdBuffer.size() < ServerProps.request_fileSizeThreshold) {
            this.size = thresholdBuffer.size();
            this.content = new ByteArrayInputStream(thresholdBuffer.toByteArray());
        } else {
            Path tempdir = ServerProps.request_tempDir.toPath();
            this.tempfile = Files.createTempFile(tempdir, "solon.", ".tmp", new FileAttribute[0]).toFile();
            try (BufferedOutputStream outs = new BufferedOutputStream(new FileOutputStream(this.tempfile));){
                ((OutputStream)outs).write(thresholdBuffer.toByteArray());
                IoUtil.transferTo((InputStream)ins, (OutputStream)outs);
            }
            this.size = this.tempfile.length();
            this.content = new FileInputStream(this.tempfile);
        }
    }

    public void delete() throws IOException {
        if (this.content != null) {
            try {
                this.content.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.content = null;
        }
        if (this.tempfile != null) {
            try {
                this.tempfile.delete();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.tempfile = null;
        }
    }

    public String getFilename() {
        return this.filename;
    }

    public InputStream getContent() throws IOException {
        return this.content;
    }

    public long getSize() throws IOException {
        return this.size;
    }
}

