/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.server;

import java.io.File;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import org.noear.solon.Solon;
import org.noear.solon.Utils;
import org.noear.solon.core.util.Assert;
import org.noear.solon.core.util.IoUtil;

public class ServerProps {
    public static final boolean output_meta = Solon.cfg().getInt("solon.output.meta", 0) > 0;
    public static final String request_encoding;
    public static final int request_maxHeaderSize;
    public static final long request_maxBodySize;
    public static final long request_maxFileSize;
    public static final int request_fileSizeThreshold;
    @Deprecated
    public static final boolean request_useTempfile;
    public static final File request_tempDir;
    public static final boolean request_useRawpath;
    public static final String response_encoding;

    public static int request_maxBodySizeAsInt() {
        if (request_maxBodySize > Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        return (int)request_maxBodySize;
    }

    public static long request_maxFileRequestSize() {
        if (request_maxBodySize > request_maxFileSize) {
            return request_maxBodySize;
        }
        return request_maxFileSize;
    }

    public static void init() {
    }

    public static String urlDecode(String str) throws UnsupportedEncodingException {
        return URLDecoder.decode(str, request_encoding);
    }

    static void synProps(String appProp, String sysProp) {
        String tmp = Solon.cfg().get(appProp);
        if (tmp != null) {
            System.getProperties().putIfAbsent(sysProp, tmp);
        }
    }

    static long getSize(String tmp, long def) {
        if (Assert.isEmpty((String)tmp)) {
            return def;
        }
        if (tmp.endsWith("mb")) {
            long val = Long.parseLong(tmp.substring(0, tmp.length() - 2));
            return val * 1024L * 1024L;
        }
        if (tmp.endsWith("kb")) {
            long val = Long.parseLong(tmp.substring(0, tmp.length() - 2));
            return val * 1024L;
        }
        long val = Long.parseLong(tmp);
        if (val < 0L) {
            return -1L;
        }
        return val;
    }

    static {
        request_tempDir = IoUtil.getTempDirAsFile((String)"solon-server");
        String tmp = null;
        tmp = Solon.cfg().get("server.request.fileSizeThreshold", "").trim().toLowerCase();
        request_fileSizeThreshold = (int)ServerProps.getSize(tmp, 524288L);
        tmp = Solon.cfg().get("server.request.maxHeaderSize", "").trim().toLowerCase();
        request_maxHeaderSize = (int)ServerProps.getSize(tmp, 8192L);
        tmp = Solon.cfg().get("server.request.maxBodySize", "").trim().toLowerCase();
        if (Utils.isEmpty((String)tmp)) {
            tmp = Solon.cfg().get("server.request.maxRequestSize", "").trim().toLowerCase();
        }
        request_maxBodySize = ServerProps.getSize(tmp, 0x200000L);
        tmp = Solon.cfg().get("server.request.maxFileSize", "").trim().toLowerCase();
        request_maxFileSize = Utils.isEmpty((String)tmp) ? request_maxBodySize : ServerProps.getSize(tmp, 0x200000L);
        tmp = Solon.cfg().get("server.request.encoding", "").trim();
        request_encoding = Utils.isEmpty((String)tmp) ? Solon.encoding() : tmp;
        request_useTempfile = Solon.cfg().getBool("server.request.useTempfile", false);
        request_useRawpath = Solon.cfg().getBool("server.request.useRawpath", false);
        tmp = Solon.cfg().get("server.response.encoding", "").trim();
        response_encoding = Utils.isEmpty((String)tmp) ? Solon.encoding() : tmp;
    }
}

