/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.server.handle;

import java.io.File;
import java.io.IOException;
import java.util.zip.GZIPOutputStream;
import org.noear.solon.Solon;
import org.noear.solon.Utils;
import org.noear.solon.core.handle.Context;
import org.noear.solon.core.handle.DownloadedFile;
import org.noear.solon.core.handle.UploadedFile;
import org.noear.solon.core.util.KeyValues;
import org.noear.solon.core.util.MultiMap;
import org.noear.solon.lang.NonNull;
import org.noear.solon.server.ServerProps;
import org.noear.solon.server.util.DecodeUtils;
import org.noear.solon.server.util.OutputUtils;

public abstract class ContextBase
extends Context {
    private String path;
    private String contentCharset;
    protected final MultiMap<UploadedFile> _fileMap = new MultiMap();

    public String path() {
        if (this.path == null && this.url() != null) {
            this.path = ServerProps.request_useRawpath ? this.uri().getRawPath() : this.uri().getPath();
            if (this.path == null) {
                this.path = "";
            }
            if (this.path.contains("//")) {
                this.path = Utils.trimDuplicates((String)this.path, (char)'/');
            }
        }
        return this.path;
    }

    public String contentType() {
        return this.header("Content-Type");
    }

    public String contentCharset() {
        if (this.contentCharset == null) {
            this.contentCharset = DecodeUtils.extractQuotedValueFromHeader(this.contentType(), "charset");
            if (Utils.isEmpty((String)this.contentCharset)) {
                this.contentCharset = ServerProps.request_encoding;
            }
            if (Utils.isEmpty((String)this.contentCharset)) {
                this.contentCharset = Solon.encoding();
            }
        }
        return this.contentCharset;
    }

    public GZIPOutputStream outputStreamAsGzip() throws IOException {
        this.headerSet("Vary", "Accept-Encoding");
        this.headerSet("Content-Encoding", "gzip");
        return new GZIPOutputStream(this.outputStream(), 4096, true);
    }

    public void outputAsFile(DownloadedFile file) throws IOException {
        OutputUtils.global().outputFile((Context)this, file, file.isAttachment());
    }

    public void outputAsFile(File file) throws IOException {
        OutputUtils.global().outputFile((Context)this, file, true);
    }

    public final String sessionId() {
        return this.sessionState().sessionId();
    }

    public final <T> T session(String name, Class<T> clz) {
        return (T)this.sessionState().sessionGet(name, clz);
    }

    public final <T> T sessionOrDefault(String name, @NonNull T def) {
        if (def == null) {
            return (T)this.session(name, Object.class);
        }
        Object tmp = this.session(name, def.getClass());
        if (tmp == null) {
            return def;
        }
        return (T)tmp;
    }

    public final int sessionAsInt(String name) {
        return this.sessionAsInt(name, 0);
    }

    public final int sessionAsInt(String name, int def) {
        String str;
        Object tmp = this.session(name, Object.class);
        if (tmp == null) {
            return def;
        }
        if (tmp instanceof Number) {
            return ((Number)tmp).intValue();
        }
        if (tmp instanceof String && (str = (String)tmp).length() > 0) {
            return Integer.parseInt(str);
        }
        return def;
    }

    public final long sessionAsLong(String name) {
        return this.sessionAsLong(name, 0L);
    }

    public final long sessionAsLong(String name, long def) {
        String str;
        Object tmp = this.session(name, Object.class);
        if (tmp == null) {
            return def;
        }
        if (tmp instanceof Number) {
            return ((Number)tmp).longValue();
        }
        if (tmp instanceof String && (str = (String)tmp).length() > 0) {
            return Long.parseLong(str);
        }
        return def;
    }

    public final double sessionAsDouble(String name) {
        return this.sessionAsDouble(name, 0.0);
    }

    public final double sessionAsDouble(String name, double def) {
        String str;
        Object tmp = this.session(name, Object.class);
        if (tmp == null) {
            return def;
        }
        if (tmp instanceof Number) {
            return ((Number)tmp).doubleValue();
        }
        if (tmp instanceof String && (str = (String)tmp).length() > 0) {
            return Double.parseDouble(str);
        }
        return def;
    }

    public final void sessionSet(String name, Object val) {
        this.sessionState().sessionSet(name, val);
    }

    public final void sessionRemove(String name) {
        this.sessionState().sessionRemove(name);
    }

    public final void sessionClear() {
        this.sessionState().sessionClear();
    }

    public void sessionReset() {
        this.sessionState().sessionReset();
    }

    public void filesDelete() throws IOException {
        for (KeyValues kv : this._fileMap) {
            for (UploadedFile file : kv.getValues()) {
                file.delete();
            }
        }
    }

    protected void innerCommit() throws IOException {
    }
}

