/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.server.websocket.integration;

import java.net.Inet4Address;
import org.noear.solon.Solon;
import org.noear.solon.Utils;
import org.noear.solon.core.AppContext;
import org.noear.solon.core.Plugin;
import org.noear.solon.core.Signal;
import org.noear.solon.core.SignalSim;
import org.noear.solon.core.SignalType;
import org.noear.solon.core.bean.LifecycleBean;
import org.noear.solon.server.ServerProps;
import org.noear.solon.server.prop.impl.WebSocketServerProps;
import org.noear.solon.server.websocket.JavaWsServer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JavaWsPlugin
implements Plugin {
    static final Logger log = LoggerFactory.getLogger(JavaWsPlugin.class);
    private static Signal _signal;
    private JavaWsServer _server = null;

    public static Signal signal() {
        return _signal;
    }

    public static String solon_server_ver() {
        return "org.java_websocket 1.5/" + Solon.version();
    }

    public void start(final AppContext context) throws Throwable {
        if (!context.app().enableWebSocket()) {
            return;
        }
        if (context.isStarted()) {
            this.start0(context);
        } else {
            context.lifecycle(99, new LifecycleBean(){

                public void postStart() throws Throwable {
                    JavaWsPlugin.this.start0(context);
                }
            });
        }
    }

    private void start0(AppContext context) throws Throwable {
        ServerProps.init();
        WebSocketServerProps props = WebSocketServerProps.getNew();
        String _host = props.getHost();
        int _port = props.getPort();
        long time_start = System.currentTimeMillis();
        this._server = Utils.isEmpty((String)_host) ? new JavaWsServer(props, _port) : new JavaWsServer(props, Inet4Address.getByName(_host), _port);
        this._server.setReuseAddr(true);
        this._server.start();
        if (Utils.isNotEmpty((String)props.getName())) {
            _signal = new SignalSim(props.getName(), props.getWrapHost(), props.getWrapPort(), "ws", SignalType.WEBSOCKET);
            context.app().signalAdd(_signal);
        }
        long time_end = System.currentTimeMillis();
        String wsServerUrl = props.buildWsServerUrl(false);
        log.info("Connector:main: websocket: Started ServerConnector@{HTTP/1.1,[WebSocket]}{" + wsServerUrl + "}");
        log.info("Server:main: websocket: Started (" + JavaWsPlugin.solon_server_ver() + ") @" + (time_end - time_start) + "ms");
    }

    public void stop() throws Throwable {
        if (this._server != null) {
            this._server.stop();
            this._server = null;
            log.info("Server:main: websocket: Has Stopped (" + JavaWsPlugin.solon_server_ver() + ")");
        }
    }
}

