/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.server.websocket;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.URI;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Iterator;
import org.java_websocket.WebSocket;
import org.java_websocket.drafts.Draft;
import org.java_websocket.exceptions.InvalidDataException;
import org.java_websocket.framing.Framedata;
import org.java_websocket.handshake.ClientHandshake;
import org.java_websocket.handshake.ServerHandshakeBuilder;
import org.java_websocket.server.WebSocketServer;
import org.noear.solon.Utils;
import org.noear.solon.core.util.RunUtil;
import org.noear.solon.net.websocket.SubProtocolCapable;
import org.noear.solon.net.websocket.WebSocketRouter;
import org.noear.solon.server.prop.impl.WebSocketServerProps;
import org.noear.solon.server.util.DecodeUtils;
import org.noear.solon.server.websocket.WebSocketImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JavaWsServer
extends WebSocketServer {
    static final Logger log = LoggerFactory.getLogger(JavaWsServer.class);
    private final WebSocketServerProps wsProps;
    private final WebSocketRouter webSocketRouter = WebSocketRouter.getInstance();

    public JavaWsServer(WebSocketServerProps props, int port) {
        super(new InetSocketAddress(port));
        this.wsProps = props;
    }

    public JavaWsServer(WebSocketServerProps props, InetAddress address, int port) {
        super(new InetSocketAddress(address, port));
        this.wsProps = props;
    }

    public void onStart() {
        log.info("Server:Websocket onStart...");
    }

    private WebSocketImpl getSession(WebSocket conn) {
        return this.getSession(conn, null);
    }

    private WebSocketImpl getSession(WebSocket conn, ClientHandshake shake) {
        WebSocketImpl session = (WebSocketImpl)((Object)conn.getAttachment());
        if (session == null) {
            session = new WebSocketImpl(conn);
            conn.setAttachment((Object)session);
            if (shake != null) {
                Iterator httpFields = shake.iterateHttpFields();
                while (httpFields.hasNext()) {
                    String name = (String)httpFields.next();
                    session.param(name, shake.getFieldValue(name));
                }
            }
        }
        return session;
    }

    public ServerHandshakeBuilder onWebsocketHandshakeReceivedAsServer(WebSocket conn, Draft draft, ClientHandshake request) throws InvalidDataException {
        String reqProtocols;
        String protocols;
        ServerHandshakeBuilder tmp = super.onWebsocketHandshakeReceivedAsServer(conn, draft, request);
        String uri = DecodeUtils.rinseUri((String)request.getResourceDescriptor());
        String path = URI.create(uri).getPath();
        SubProtocolCapable subProtocolCapable = this.webSocketRouter.getSubProtocol(path);
        if (subProtocolCapable != null && Utils.isNotEmpty((String)(protocols = subProtocolCapable.getSubProtocols(Arrays.asList((reqProtocols = Utils.annoAlias((String)request.getFieldValue("Sec-WebSocket-Protocol"), (String)"")).split(",")))))) {
            tmp.put("Sec-WebSocket-Protocol", protocols);
        }
        return tmp;
    }

    public void onOpen(WebSocket conn, ClientHandshake shake) {
        WebSocketImpl webSocket = this.getSession(conn, shake);
        this.webSocketRouter.getListener().onOpen((org.noear.solon.net.websocket.WebSocket)webSocket);
        if (this.wsProps.getIdleTimeout() > 0L) {
            webSocket.setIdleTimeout(this.wsProps.getIdleTimeout());
        }
    }

    public void onClose(WebSocket conn, int i, String s, boolean b) {
        WebSocketImpl webSocket = this.getSession(conn);
        if (webSocket.isClosed()) {
            return;
        }
        RunUtil.runAndTry(webSocket::close);
        this.webSocketRouter.getListener().onClose((org.noear.solon.net.websocket.WebSocket)webSocket);
    }

    public void onWebsocketPing(WebSocket conn, Framedata f) {
        super.onWebsocketPing(conn, f);
        WebSocketImpl webSocket = this.getSession(conn);
        if (webSocket != null) {
            webSocket.onReceive();
        }
        this.webSocketRouter.getListener().onPing((org.noear.solon.net.websocket.WebSocket)webSocket);
    }

    public void onWebsocketPong(WebSocket conn, Framedata f) {
        super.onWebsocketPong(conn, f);
        WebSocketImpl webSocket = this.getSession(conn);
        if (webSocket != null) {
            webSocket.onReceive();
        }
        this.webSocketRouter.getListener().onPong((org.noear.solon.net.websocket.WebSocket)webSocket);
    }

    public void onMessage(WebSocket conn, String data) {
        try {
            WebSocketImpl webSocket = this.getSession(conn);
            webSocket.onReceive();
            this.webSocketRouter.getListener().onMessage((org.noear.solon.net.websocket.WebSocket)webSocket, data);
        }
        catch (Exception e) {
            this.onError(conn, e);
        }
    }

    public void onMessage(WebSocket conn, ByteBuffer data) {
        try {
            WebSocketImpl webSocket = this.getSession(conn);
            webSocket.onReceive();
            this.webSocketRouter.getListener().onMessage((org.noear.solon.net.websocket.WebSocket)webSocket, data);
        }
        catch (Exception e) {
            this.onError(conn, e);
        }
    }

    public void onError(WebSocket conn, Exception ex) {
        try {
            WebSocketImpl webSocket = this.getSession(conn);
            this.webSocketRouter.getListener().onError((org.noear.solon.net.websocket.WebSocket)webSocket, (Throwable)ex);
        }
        catch (Throwable e) {
            log.warn(e.getMessage(), e);
        }
    }
}

