/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.server.websocket;

import java.net.InetSocketAddress;
import java.net.URI;
import java.nio.ByteBuffer;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import org.java_websocket.WebSocket;
import org.noear.solon.core.util.RunUtil;
import org.noear.solon.net.websocket.WebSocketTimeoutBase;
import org.noear.solon.server.util.DecodeUtils;

public class WebSocketImpl
extends WebSocketTimeoutBase {
    private final WebSocket real;

    public WebSocketImpl(WebSocket real) {
        this.real = real;
        String uri = DecodeUtils.rinseUri((String)real.getResourceDescriptor());
        this.init(URI.create(uri));
    }

    public boolean isValid() {
        return !this.isClosed() && this.real.isOpen();
    }

    public boolean isSecure() {
        return this.real.hasSSLSupport();
    }

    public InetSocketAddress remoteAddress() {
        return this.real.getRemoteSocketAddress();
    }

    public InetSocketAddress localAddress() {
        return this.real.getLocalSocketAddress();
    }

    public Future<Void> send(String text) {
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        try {
            this.real.send(text);
            this.onSend();
            future.complete(null);
        }
        catch (Throwable ex) {
            future.completeExceptionally(ex);
        }
        return future;
    }

    public Future<Void> send(ByteBuffer binary) {
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        try {
            this.real.send(binary);
            this.onSend();
            future.complete(null);
        }
        catch (Throwable ex) {
            future.completeExceptionally(ex);
        }
        return future;
    }

    public void close() {
        super.close();
        if (this.real.isOpen()) {
            RunUtil.runAndTry(() -> ((WebSocket)this.real).close());
        }
    }
}

