/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.server.vertx.websocket;

import io.vertx.core.Handler;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.ServerWebSocket;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.URI;
import java.nio.ByteBuffer;
import java.util.concurrent.Future;
import org.noear.solon.Utils;
import org.noear.solon.core.util.RunUtil;
import org.noear.solon.net.websocket.WebSocketTimeoutBase;
import org.noear.solon.server.util.DecodeUtils;
import org.noear.solon.server.vertx.websocket.CallbackFuture;

public class VxWebSocketImpl
extends WebSocketTimeoutBase {
    private ServerWebSocket real;

    public VxWebSocketImpl(ServerWebSocket real) {
        this.real = real;
        String uri = this.buildUri(real);
        this.init(URI.create(uri));
    }

    public String buildUri(ServerWebSocket req) {
        if (Utils.isEmpty((String)req.query())) {
            return DecodeUtils.rinseUri((String)req.uri());
        }
        if (req.uri().contains("?")) {
            return DecodeUtils.rinseUri((String)req.uri());
        }
        return DecodeUtils.rinseUri((String)req.uri()) + "?" + req.query();
    }

    public boolean isValid() {
        return !this.isClosed();
    }

    public boolean isSecure() {
        return this.real.isSsl();
    }

    public InetSocketAddress remoteAddress() throws IOException {
        return (InetSocketAddress)this.real.remoteAddress();
    }

    public InetSocketAddress localAddress() throws IOException {
        return (InetSocketAddress)this.real.localAddress();
    }

    public Future<Void> send(String text) {
        CallbackFuture future = new CallbackFuture();
        this.real.writeFinalTextFrame(text, (Handler)future);
        this.onSend();
        return future;
    }

    public Future<Void> send(ByteBuffer binary) {
        CallbackFuture future = new CallbackFuture();
        this.real.writeBinaryMessage(Buffer.buffer((byte[])binary.array()), (Handler)future);
        this.onSend();
        return future;
    }

    public void close() {
        super.close();
        if (!this.real.isClosed()) {
            RunUtil.runAndTry(() -> ((ServerWebSocket)this.real).close());
        }
    }
}

