/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.server.vertx;

import io.vertx.core.Vertx;
import io.vertx.core.http.HttpServer;
import io.vertx.core.http.HttpServerOptions;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.http.ServerWebSocket;
import io.vertx.core.net.JksOptions;
import io.vertx.core.net.KeyCertOptions;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLContext;
import org.noear.solon.Utils;
import org.noear.solon.core.AppContext;
import org.noear.solon.core.handle.Handler;
import org.noear.solon.lang.Nullable;
import org.noear.solon.server.ServerLifecycle;
import org.noear.solon.server.ServerProps;
import org.noear.solon.server.prop.impl.HttpServerProps;
import org.noear.solon.server.ssl.SslConfig;
import org.noear.solon.server.vertx.http.VxHandlerSupplier;
import org.noear.solon.server.vertx.http.VxHandlerSupplierDefault;
import org.noear.solon.server.vertx.websocket.VxWebSocketHandlerImpl;
import org.noear.solon.web.vertx.VxHandler;

public class VxHttpServer
implements ServerLifecycle {
    private final HttpServerProps props;
    private final AppContext context;
    private HttpServer server = null;
    private Handler handler;
    private Executor workExecutor;
    private boolean enableWebSocket;
    private boolean enableHttp2;
    private SslConfig sslConfig = new SslConfig("http");
    private boolean isSecure;
    private boolean allowExternalHandler;

    public VxHttpServer(HttpServerProps props, AppContext context, boolean allowExternalHandler) {
        this.props = props;
        this.allowExternalHandler = allowExternalHandler;
        this.context = context;
    }

    public boolean isSecure() {
        return this.isSecure;
    }

    public void enableSsl(boolean enable, @Nullable SSLContext sslContext) {
        this.sslConfig.set(enable, sslContext);
    }

    public void enableHttp2(boolean enable) {
        this.enableHttp2 = enable;
    }

    public void enableWebSocket(boolean enableWebSocket) {
        this.enableWebSocket = enableWebSocket;
    }

    public void setHandler(Handler handler) {
        this.handler = handler;
    }

    public void setWorkExecutor(Executor executor) {
        this.workExecutor = executor;
    }

    public void start(String host, int port) throws Throwable {
        Vertx _vertx = (Vertx)this.context.getBean(Vertx.class);
        VxHandlerSupplier handlerFactory = null;
        if (this.allowExternalHandler) {
            handlerFactory = (VxHandlerSupplier)this.context.getBean(VxHandlerSupplier.class);
        }
        if (handlerFactory == null) {
            handlerFactory = new VxHandlerSupplierDefault();
        }
        HttpServerOptions _serverOptions = new HttpServerOptions();
        _serverOptions.setMaxHeaderSize(ServerProps.request_maxHeaderSize);
        if (this.sslConfig.isSslEnable()) {
            _serverOptions.setSsl(true).setKeyCertOptions((KeyCertOptions)new JksOptions().setPath(this.sslConfig.getProps().getSslKeyStore()).setPassword(this.sslConfig.getProps().getSslKeyPassword()));
            if (this.enableHttp2) {
                _serverOptions.setUseAlpn(true);
            }
            this.isSecure = _serverOptions.isSsl();
        }
        if (this.enableWebSocket) {
            _serverOptions.addWebSocketSubProtocol("*");
        }
        _serverOptions.setIdleTimeout((int)this.props.getIdleTimeoutOrDefault());
        _serverOptions.setIdleTimeoutUnit(TimeUnit.MILLISECONDS);
        VxHandler vxHandler = (VxHandler)handlerFactory.get();
        vxHandler.setExecutor(this.workExecutor);
        vxHandler.setHandler(this.handler);
        VxWebSocketHandlerImpl vxWebSocketHandlerImpl = new VxWebSocketHandlerImpl();
        this.server = _vertx.createHttpServer(_serverOptions);
        this.server.requestHandler(req -> {
            String upgradeStr;
            if (this.enableWebSocket && Utils.isNotEmpty((String)(upgradeStr = req.getHeader("Upgrade"))) && upgradeStr.contains("websocket")) {
                vxWebSocketHandlerImpl.subProtocolCapable((HttpServerRequest)req);
                req.toWebSocket().onSuccess(ws -> vxWebSocketHandlerImpl.handle((ServerWebSocket)ws));
                return;
            }
            vxHandler.handle(req);
        });
        if (Utils.isNotEmpty((String)host)) {
            this.server.listen(port, host);
        } else {
            this.server.listen(port);
        }
    }

    public void stop() throws Throwable {
        if (this.server != null) {
            this.server.close();
        }
    }
}

