/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.serialization.jackson.xml;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.cfg.ConfigFeature;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.dataformat.xml.XmlMapper;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.noear.solon.core.util.Assert;

public class JacksonXmlDecl<F extends ConfigFeature> {
    private XmlMapper mapper = new XmlMapper();
    private Set<F> featuresSet = new HashSet<F>();
    private SimpleModule customModule = new SimpleModule();

    public XmlMapper getMapper() {
        return this.mapper;
    }

    public void setMapper(XmlMapper mapper) {
        Assert.notNull((Object)mapper, (String)"mapper can't be null");
        this.mapper = mapper;
    }

    public SimpleModule getCustomModule() {
        return this.customModule;
    }

    public void setFeatures(F ... features) {
        this.featuresSet.clear();
        this.featuresSet.addAll(Arrays.asList(features));
    }

    public void addFeatures(F ... features) {
        this.featuresSet.addAll(Arrays.asList(features));
    }

    public void removeFeatures(F ... features) {
        this.featuresSet.removeAll(Arrays.asList(features));
    }

    protected void refresh() {
        for (ConfigFeature f1 : this.featuresSet) {
            if (f1 instanceof SerializationFeature) {
                this.mapper.enable((SerializationFeature)f1);
                continue;
            }
            if (!(f1 instanceof DeserializationFeature)) continue;
            this.mapper.enable((DeserializationFeature)f1);
        }
        if (this.customModule != null) {
            this.mapper.registerModule((Module)this.customModule);
        }
    }
}

