/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.serialization.jackson.xml;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.PropertyAccessor;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.cfg.ConfigFeature;
import com.fasterxml.jackson.dataformat.xml.deser.FromXmlParser;
import com.fasterxml.jackson.dataformat.xml.ser.ToXmlGenerator;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import java.util.Collection;
import java.util.List;
import org.noear.solon.core.handle.Context;
import org.noear.solon.core.util.LazyReference;
import org.noear.solon.core.wrap.MethodWrap;
import org.noear.solon.core.wrap.ParamWrap;
import org.noear.solon.serialization.AbstractStringEntityConverter;
import org.noear.solon.serialization.EntitySerializer;
import org.noear.solon.serialization.jackson.xml.JacksonXmlStringSerializer;
import org.noear.solon.serialization.jackson.xml.impl.TypeReferenceImpl;

public class JacksonXmlEntityConverter
extends AbstractStringEntityConverter<JacksonXmlStringSerializer> {
    public JacksonXmlEntityConverter(JacksonXmlStringSerializer serializer) {
        super((EntitySerializer)serializer);
        serializer.getDeserializeConfig().getMapper().enable(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS);
        serializer.getDeserializeConfig().getMapper().configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        serializer.getDeserializeConfig().getMapper().setVisibility(PropertyAccessor.ALL, JsonAutoDetect.Visibility.ANY);
        serializer.getDeserializeConfig().getMapper().activateDefaultTypingAsProperty(serializer.getDeserializeConfig().getMapper().getPolymorphicTypeValidator(), ObjectMapper.DefaultTyping.JAVA_LANG_OBJECT, "@type");
        serializer.getDeserializeConfig().getMapper().registerModule((Module)new JavaTimeModule());
        serializer.getDeserializeConfig().getMapper().configure(FromXmlParser.Feature.EMPTY_ELEMENT_AS_NULL, true);
        serializer.getDeserializeConfig().getMapper().configure(ToXmlGenerator.Feature.WRITE_XML_DECLARATION, false);
        serializer.getSerializeConfig().addFeatures((ConfigFeature[])new SerializationFeature[]{SerializationFeature.WRITE_DATES_AS_TIMESTAMPS});
        serializer.getSerializeConfig().getMapper().registerModule((Module)new JavaTimeModule());
    }

    public String[] mappings() {
        return new String[]{"@xml"};
    }

    protected Object changeBody(Context ctx, MethodWrap mWrap) throws Exception {
        return ((JacksonXmlStringSerializer)this.serializer).deserializeFromBody(ctx);
    }

    protected Object changeValue(Context ctx, ParamWrap p, int pi, Class<?> pt, LazyReference bodyRef) throws Throwable {
        if (p.spec().isRequiredPath() || p.spec().isRequiredCookie() || p.spec().isRequiredHeader()) {
            return super.changeValue(ctx, p, pi, pt, bodyRef);
        }
        if (!p.spec().isRequiredBody() && ctx.paramMap().containsKey(p.spec().getName())) {
            return super.changeValue(ctx, p, pi, pt, bodyRef);
        }
        Object bodyObj = bodyRef.get();
        if (bodyObj == null) {
            return super.changeValue(ctx, p, pi, pt, bodyRef);
        }
        JsonNode tmp = (JsonNode)bodyObj;
        if (tmp.isObject()) {
            if (!p.spec().isRequiredBody() && tmp.has(p.spec().getName())) {
                JsonNode m1 = tmp.get(p.spec().getName());
                return ((JacksonXmlStringSerializer)this.serializer).getDeserializeConfig().getMapper().readValue(((JacksonXmlStringSerializer)this.serializer).getDeserializeConfig().getMapper().treeAsTokens((TreeNode)m1), new TypeReferenceImpl(p));
            }
            if (pt.isPrimitive() || pt.getTypeName().startsWith("java.lang.")) {
                return super.changeValue(ctx, p, pi, pt, bodyRef);
            }
            if (List.class.isAssignableFrom(pt)) {
                return null;
            }
            if (pt.isArray()) {
                return null;
            }
            return ((JacksonXmlStringSerializer)this.serializer).getDeserializeConfig().getMapper().readValue(((JacksonXmlStringSerializer)this.serializer).getDeserializeConfig().getMapper().treeAsTokens((TreeNode)tmp), new TypeReferenceImpl(p));
        }
        if (tmp.isArray()) {
            if (!Collection.class.isAssignableFrom(pt)) {
                return null;
            }
            return ((JacksonXmlStringSerializer)this.serializer).getDeserializeConfig().getMapper().readValue(((JacksonXmlStringSerializer)this.serializer).getDeserializeConfig().getMapper().treeAsTokens((TreeNode)tmp), new TypeReferenceImpl(p));
        }
        if (tmp.isValueNode()) {
            return ((JacksonXmlStringSerializer)this.serializer).getDeserializeConfig().getMapper().readValue(((JacksonXmlStringSerializer)this.serializer).getDeserializeConfig().getMapper().treeAsTokens((TreeNode)tmp), new TypeReferenceImpl(p));
        }
        return null;
    }
}

