/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.serialization.fastjson2;

import com.alibaba.fastjson2.JSON;
import com.alibaba.fastjson2.JSONReader;
import com.alibaba.fastjson2.JSONWriter;
import com.alibaba.fastjson2.reader.ObjectReaderProvider;
import com.alibaba.fastjson2.writer.ObjectWriter;
import com.alibaba.fastjson2.writer.ObjectWriterProvider;
import java.io.IOException;
import java.lang.reflect.Type;
import org.noear.solon.Utils;
import org.noear.solon.core.convert.Converter;
import org.noear.solon.core.handle.Context;
import org.noear.solon.core.handle.ModelAndView;
import org.noear.solon.lang.Nullable;
import org.noear.solon.serialization.EntityStringSerializer;
import org.noear.solon.serialization.fastjson2.Fastjson2Decl;
import org.noear.solon.serialization.prop.JsonProps;
import org.noear.solon.serialization.prop.JsonPropsUtil2;

public class Fastjson2StringSerializer
implements EntityStringSerializer {
    private static final String label = "/json";
    private static final Fastjson2StringSerializer _default = new Fastjson2StringSerializer();
    private Fastjson2Decl<JSONWriter.Context, JSONWriter.Feature> serializeConfig;
    private Fastjson2Decl<JSONReader.Context, JSONReader.Feature> deserializeConfig;

    public static Fastjson2StringSerializer getDefault() {
        return _default;
    }

    public Fastjson2StringSerializer(JsonProps jsonProps) {
        this.loadJsonProps(jsonProps);
    }

    public Fastjson2StringSerializer() {
    }

    public Fastjson2Decl<JSONWriter.Context, JSONWriter.Feature> getSerializeConfig() {
        if (this.serializeConfig == null) {
            this.serializeConfig = new Fastjson2Decl(new JSONWriter.Context(new ObjectWriterProvider()));
        }
        return this.serializeConfig;
    }

    public Fastjson2Decl<JSONReader.Context, JSONReader.Feature> getDeserializeConfig() {
        if (this.deserializeConfig == null) {
            this.deserializeConfig = new Fastjson2Decl(new JSONReader.Context(new ObjectReaderProvider()));
        }
        return this.deserializeConfig;
    }

    public String mimeType() {
        return "application/json";
    }

    public Class<String> dataType() {
        return String.class;
    }

    public boolean matched(Context ctx, String mime) {
        if (mime == null) {
            return false;
        }
        return mime.contains(label) || mime.startsWith("application/x-ndjson");
    }

    public String name() {
        return "fastjson2-json";
    }

    public String serialize(Object obj) throws IOException {
        return JSON.toJSONString((Object)obj, (JSONWriter.Context)this.getSerializeConfig().getContext());
    }

    public Object deserialize(String data, Type toType) throws IOException {
        if (toType == null) {
            return JSON.parse((String)data, (JSONReader.Context)this.getDeserializeConfig().getContext());
        }
        return JSON.parseObject((String)data, (Type)toType, (JSONReader.Context)this.getDeserializeConfig().getContext());
    }

    public void serializeToBody(Context ctx, Object data) throws IOException {
        if (ctx.contentTypeNew() == null) {
            ctx.contentType(this.mimeType());
        }
        if (data instanceof ModelAndView) {
            ctx.output(this.serialize(((ModelAndView)data).model()));
        } else {
            ctx.output(this.serialize(data));
        }
    }

    public Object deserializeFromBody(Context ctx, @Nullable Type bodyType) throws IOException {
        String data = ctx.bodyNew();
        if (Utils.isNotEmpty((String)data)) {
            return JSON.parse((String)data, (JSONReader.Context)this.getDeserializeConfig().getContext());
        }
        return null;
    }

    public <T> void addEncoder(Class<T> clz, ObjectWriter encoder) {
        this.getSerializeConfig().getContext().getProvider().register(clz, encoder);
    }

    public <T> void addEncoder(Class<T> clz, Converter<T, Object> converter) {
        this.addEncoder(clz, (out, obj, fieldName, fieldType, features) -> {
            Object val = converter.convert(obj);
            if (val == null) {
                out.writeNull();
            } else if (val instanceof String) {
                out.writeString((String)val);
            } else if (val instanceof Number) {
                if (val instanceof Long) {
                    out.writeInt64(((Number)val).longValue());
                } else if (val instanceof Integer) {
                    out.writeInt32(((Number)val).intValue());
                } else if (val instanceof Float) {
                    out.writeDouble((double)((Number)val).floatValue());
                } else {
                    out.writeDouble(((Number)val).doubleValue());
                }
            } else {
                throw new IllegalArgumentException("The result type of the converter is not supported: " + val.getClass().getName());
            }
        });
    }

    protected void loadJsonProps(JsonProps jsonProps) {
        if (jsonProps != null) {
            boolean writeNulls;
            if (jsonProps.dateAsTicks) {
                jsonProps.dateAsTicks = false;
                this.getSerializeConfig().getContext().setDateFormat("millis");
            }
            if (Utils.isNotEmpty((String)jsonProps.dateAsFormat)) {
                this.getSerializeConfig().getContext().setDateFormat(jsonProps.dateAsFormat);
            }
            JsonPropsUtil2.dateAsTicks((EntityStringSerializer)this, (JsonProps)jsonProps);
            JsonPropsUtil2.boolAsInt((EntityStringSerializer)this, (JsonProps)jsonProps);
            boolean bl = writeNulls = jsonProps.nullAsWriteable || jsonProps.nullNumberAsZero || jsonProps.nullArrayAsEmpty || jsonProps.nullBoolAsFalse || jsonProps.nullStringAsEmpty;
            if (jsonProps.nullStringAsEmpty) {
                this.getSerializeConfig().addFeatures((JSONWriter.Feature[])new JSONWriter.Feature[]{JSONWriter.Feature.WriteNullStringAsEmpty});
            }
            if (jsonProps.nullBoolAsFalse) {
                this.getSerializeConfig().addFeatures((JSONWriter.Feature[])new JSONWriter.Feature[]{JSONWriter.Feature.WriteNullBooleanAsFalse});
            }
            if (jsonProps.nullNumberAsZero) {
                this.getSerializeConfig().addFeatures((JSONWriter.Feature[])new JSONWriter.Feature[]{JSONWriter.Feature.WriteNullNumberAsZero});
            }
            if (jsonProps.boolAsInt) {
                this.getSerializeConfig().addFeatures((JSONWriter.Feature[])new JSONWriter.Feature[]{JSONWriter.Feature.WriteBooleanAsNumber});
            }
            if (jsonProps.longAsString) {
                this.getSerializeConfig().addFeatures((JSONWriter.Feature[])new JSONWriter.Feature[]{JSONWriter.Feature.WriteLongAsString});
            }
            if (jsonProps.nullArrayAsEmpty) {
                this.getSerializeConfig().addFeatures((JSONWriter.Feature[])new JSONWriter.Feature[]{JSONWriter.Feature.WriteNullListAsEmpty});
            }
            if (jsonProps.enumAsName) {
                this.getSerializeConfig().addFeatures((JSONWriter.Feature[])new JSONWriter.Feature[]{JSONWriter.Feature.WriteEnumsUsingName});
            }
            if (writeNulls) {
                this.getSerializeConfig().addFeatures((JSONWriter.Feature[])new JSONWriter.Feature[]{JSONWriter.Feature.WriteNulls});
            }
        }
    }
}

