/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.serialization.fastjson2;

import com.alibaba.fastjson2.JSONArray;
import com.alibaba.fastjson2.JSONObject;
import com.alibaba.fastjson2.JSONReader;
import java.util.Collection;
import java.util.List;
import org.noear.solon.core.handle.Context;
import org.noear.solon.core.mvc.ActionExecuteHandlerDefault;
import org.noear.solon.core.wrap.MethodWrap;
import org.noear.solon.core.wrap.ParamWrap;
import org.noear.solon.serialization.fastjson2.Fastjson2StringSerializer;

public class Fastjson2ActionExecutor
extends ActionExecuteHandlerDefault {
    private final Fastjson2StringSerializer serializer = new Fastjson2StringSerializer();

    public Fastjson2ActionExecutor() {
        this.serializer.getDeserializeConfig().config(new JSONReader.Feature[0]);
        this.serializer.getDeserializeConfig().config(new JSONReader.Feature[]{JSONReader.Feature.ErrorOnEnumNotMatch});
    }

    public Fastjson2StringSerializer getSerializer() {
        return this.serializer;
    }

    public JSONReader.Context config() {
        return this.getSerializer().getDeserializeConfig();
    }

    public boolean matched(Context ctx, String mime) {
        return this.serializer.matched(ctx, mime);
    }

    protected Object changeBody(Context ctx, MethodWrap mWrap) throws Exception {
        return this.serializer.deserializeFromBody(ctx);
    }

    protected Object changeValue(Context ctx, ParamWrap p, int pi, Class<?> pt, Object bodyObj) throws Exception {
        if (p.isRequiredPath() || p.isRequiredCookie() || p.isRequiredHeader()) {
            return super.changeValue(ctx, p, pi, pt, bodyObj);
        }
        if (!p.isRequiredBody() && ctx.paramMap().containsKey(p.getName())) {
            return super.changeValue(ctx, p, pi, pt, bodyObj);
        }
        if (bodyObj == null) {
            return super.changeValue(ctx, p, pi, pt, bodyObj);
        }
        if (bodyObj instanceof JSONObject) {
            JSONObject tmp = (JSONObject)bodyObj;
            if (!p.isRequiredBody() && tmp.containsKey(p.getName())) {
                if (p.isGenericType()) {
                    return tmp.getObject(p.getName(), p.getGenericType(), new JSONReader.Feature[0]);
                }
                return tmp.getObject(p.getName(), pt, new JSONReader.Feature[0]);
            }
            if (pt.isPrimitive() || pt.getTypeName().startsWith("java.lang.")) {
                return super.changeValue(ctx, p, pi, pt, bodyObj);
            }
            if (List.class.isAssignableFrom(pt)) {
                return null;
            }
            if (pt.isArray()) {
                return null;
            }
            if (p.isGenericType()) {
                return tmp.to(p.getGenericType(), new JSONReader.Feature[0]);
            }
            return tmp.to(pt, new JSONReader.Feature[0]);
        }
        if (bodyObj instanceof JSONArray) {
            JSONArray tmp = (JSONArray)bodyObj;
            if (!Collection.class.isAssignableFrom(pt)) {
                return null;
            }
            if (p.isGenericType()) {
                return tmp.to(p.getGenericType());
            }
            return tmp.to(pt);
        }
        return bodyObj;
    }
}

