/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.serialization.fastjson;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.parser.Feature;
import com.alibaba.fastjson.serializer.SerializeConfig;
import com.alibaba.fastjson.serializer.SerializerFeature;
import org.noear.solon.core.util.Assert;

public class FastjsonDecl<C, F> {
    private final boolean forSerialize;
    private C config;
    private int featuresCode;

    public FastjsonDecl(C config) {
        this.config = config;
        if (config instanceof SerializeConfig) {
            this.forSerialize = true;
            this.featuresCode = JSON.DEFAULT_GENERATE_FEATURE;
        } else {
            this.forSerialize = false;
            this.featuresCode = JSON.DEFAULT_PARSER_FEATURE;
        }
    }

    public C getConfig() {
        return this.config;
    }

    public void setConfig(C config) {
        Assert.notNull(config, (String)"config can not be null");
        this.config = config;
    }

    public int getFeatures() {
        return this.featuresCode;
    }

    public void setFeatures(F ... features) {
        if (this.forSerialize) {
            this.featuresCode = JSON.DEFAULT_GENERATE_FEATURE;
            this.addFeatures(features);
        } else {
            this.featuresCode = JSON.DEFAULT_PARSER_FEATURE;
            this.addFeatures(features);
        }
    }

    public void addFeatures(F ... features) {
        if (this.forSerialize) {
            for (F f1 : features) {
                SerializerFeature feature = (SerializerFeature)f1;
                this.featuresCode |= feature.getMask();
            }
        } else {
            for (F f1 : features) {
                Feature feature = (Feature)f1;
                this.featuresCode |= feature.getMask();
            }
        }
    }

    public void removeFeatures(F ... features) {
        if (this.forSerialize) {
            for (F f1 : features) {
                SerializerFeature feature = (SerializerFeature)f1;
                this.featuresCode &= ~feature.getMask();
            }
        } else {
            for (F f1 : features) {
                Feature feature = (Feature)f1;
                this.featuresCode &= ~feature.getMask();
            }
        }
    }
}

