/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.security.web.header;

import org.noear.solon.core.handle.Context;
import org.noear.solon.core.handle.Handler;

public class HstsHeaderHandler
implements Handler {
    private final int maxAge;
    private final boolean includeSubDomains;
    private final boolean preload;
    private final String headerValue;

    public HstsHeaderHandler() {
        this(31536000);
    }

    public HstsHeaderHandler(int maxAge) {
        this(maxAge, true);
    }

    public HstsHeaderHandler(int maxAge, boolean includeSubDomains) {
        this(maxAge, includeSubDomains, false);
    }

    public HstsHeaderHandler(int maxAge, boolean includeSubDomains, boolean preload) {
        this.maxAge = maxAge;
        this.includeSubDomains = includeSubDomains;
        this.preload = preload;
        this.headerValue = this.buildHeaderValue();
    }

    private String buildHeaderValue() {
        StringBuilder buf = new StringBuilder();
        buf.append("max-age=").append(this.maxAge);
        if (this.includeSubDomains) {
            buf.append("; includeSubDomains");
            if (this.preload) {
                buf.append("; preload");
            }
        }
        return buf.toString();
    }

    public void handle(Context ctx) throws Throwable {
        ctx.headerSet("Strict-Transport-Security=", this.headerValue);
    }
}

