/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.validation.annotation;

import org.noear.solon.Utils;
import org.noear.solon.core.handle.Context;
import org.noear.solon.core.handle.Result;
import org.noear.solon.core.util.ClassUtil;
import org.noear.solon.validation.Validator;
import org.noear.solon.validation.annotation.Range;
import org.noear.solon.validation.util.StringUtils;

public class RangeValidator
implements Validator<Range> {
    public static final RangeValidator instance = new RangeValidator();

    @Override
    public String message(Range anno) {
        return anno.message();
    }

    @Override
    public Class<?>[] groups(Range anno) {
        return anno.groups();
    }

    @Override
    public boolean isSupportValueType(Class<?> type) {
        return ClassUtil.isNumberType(type);
    }

    @Override
    public Result validateOfValue(Range anno, Object val0, StringBuilder tmp) {
        if (val0 != null && !(val0 instanceof Number)) {
            return Result.failure();
        }
        Number val = (Number)val0;
        if (!this.verify(anno, val)) {
            return Result.failure();
        }
        return Result.succeed();
    }

    @Override
    public Result validateOfContext(Context ctx, Range anno, String name, StringBuilder tmp) {
        String val = ctx.param(name);
        if (Utils.isEmpty((String)val)) {
            return Result.succeed();
        }
        if (!StringUtils.isInteger(val)) {
            return Result.failure((String)name);
        }
        if (!this.verify(anno, Long.parseLong(val))) {
            return Result.failure((String)name);
        }
        return Result.succeed();
    }

    private boolean verify(Range anno, Number val) {
        if (val == null) {
            return true;
        }
        if (anno.min() > 0L && val.longValue() < anno.min()) {
            return false;
        }
        return anno.max() <= 0L || val.longValue() <= anno.max();
    }
}

