/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.net.http.ssl;

import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.SecureRandom;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import org.noear.solon.Utils;

public class SslContextBuilder {
    private String protocol = "TLS";
    private KeyManager[] keyManagers;
    private TrustManager[] trustManagers;
    private SecureRandom secureRandom;
    private Provider provider;

    public static SslContextBuilder of() {
        return new SslContextBuilder();
    }

    public SslContextBuilder protocol(String protocol) {
        if (Utils.isNotBlank((String)protocol)) {
            this.protocol = protocol;
        }
        return this;
    }

    public SslContextBuilder trustManagers(TrustManager ... trustManagers) {
        if (Utils.isNotEmpty((Object[])trustManagers)) {
            this.trustManagers = trustManagers;
        }
        return this;
    }

    public SslContextBuilder keyManagers(KeyManager ... keyManagers) {
        if (Utils.isNotEmpty((Object[])keyManagers)) {
            this.keyManagers = keyManagers;
        }
        return this;
    }

    public SslContextBuilder secureRandom(SecureRandom secureRandom) {
        if (null != secureRandom) {
            this.secureRandom = secureRandom;
        }
        return this;
    }

    public SslContextBuilder provider(Provider provider) {
        this.provider = provider;
        return this;
    }

    public SSLContext build() throws NoSuchAlgorithmException, KeyManagementException {
        SSLContext sslContext = null != this.provider ? SSLContext.getInstance(this.protocol, this.provider) : SSLContext.getInstance(this.protocol);
        sslContext.init(this.keyManagers, this.trustManagers, this.secureRandom);
        return sslContext;
    }
}

