/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.net.http.impl.okhttp;

import java.net.Proxy;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import javax.net.ssl.HostnameVerifier;
import okhttp3.Dispatcher;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import org.noear.solon.net.http.HttpUtils;
import org.noear.solon.net.http.HttpUtilsFactory;
import org.noear.solon.net.http.impl.HttpSsl;
import org.noear.solon.net.http.impl.okhttp.OkHttpInterceptor;
import org.noear.solon.net.http.impl.okhttp.OkHttpUtils;

public class OkHttpUtilsFactory
implements HttpUtilsFactory {
    private static final Supplier<Dispatcher> httpClientDispatcher = () -> {
        Dispatcher temp = new Dispatcher();
        temp.setMaxRequests(20000);
        temp.setMaxRequestsPerHost(10000);
        return temp;
    };
    private static final OkHttpUtilsFactory instance = new OkHttpUtilsFactory();
    private Map<Proxy, OkHttpClient> proxyClients = new ConcurrentHashMap<Proxy, OkHttpClient>();
    private OkHttpClient defaultClient = OkHttpUtilsFactory.createHttpClient(null);

    private static OkHttpClient createHttpClient(Proxy proxy) {
        OkHttpClient.Builder builder = new OkHttpClient.Builder().connectTimeout(10L, TimeUnit.SECONDS).writeTimeout(10L, TimeUnit.SECONDS).readTimeout(60L, TimeUnit.SECONDS).dispatcher(httpClientDispatcher.get()).addInterceptor((Interceptor)OkHttpInterceptor.instance).sslSocketFactory(HttpSsl.getSSLSocketFactory(), HttpSsl.getX509TrustManager()).hostnameVerifier((HostnameVerifier)HttpSsl.defaultHostnameVerifier);
        if (proxy != null) {
            builder.proxy(proxy);
        }
        return builder.build();
    }

    public static OkHttpUtilsFactory getInstance() {
        return instance;
    }

    protected OkHttpClient getClient(Proxy proxy) {
        if (proxy == null) {
            return this.defaultClient;
        }
        return this.proxyClients.computeIfAbsent(proxy, k -> OkHttpUtilsFactory.createHttpClient(proxy));
    }

    @Override
    public HttpUtils http(String url) {
        return new OkHttpUtils(this, url);
    }
}

