/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.net.http.impl.okhttp;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import javax.net.ssl.HostnameVerifier;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.Dispatcher;
import okhttp3.FormBody;
import okhttp3.Interceptor;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.internal.Util;
import okio.BufferedSink;
import okio.Okio;
import okio.Source;
import org.noear.solon.core.util.KeyValues;
import org.noear.solon.core.util.MultiMap;
import org.noear.solon.net.http.HttpResponse;
import org.noear.solon.net.http.HttpUtils;
import org.noear.solon.net.http.impl.AbstractHttpUtils;
import org.noear.solon.net.http.impl.HttpSsl;
import org.noear.solon.net.http.impl.HttpStream;
import org.noear.solon.net.http.impl.HttpTimeout;
import org.noear.solon.net.http.impl.HttpUploadFile;
import org.noear.solon.net.http.impl.okhttp.OkHttpInterceptorImpl;
import org.noear.solon.net.http.impl.okhttp.OkHttpResponseImpl;

public class OkHttpUtilsImpl
extends AbstractHttpUtils
implements HttpUtils {
    private static final Supplier<Dispatcher> httpClientDispatcher = () -> {
        Dispatcher temp = new Dispatcher();
        temp.setMaxRequests(20000);
        temp.setMaxRequestsPerHost(10000);
        return temp;
    };
    private static final OkHttpClient httpClient = new OkHttpClient.Builder().connectTimeout(10L, TimeUnit.SECONDS).writeTimeout(10L, TimeUnit.SECONDS).readTimeout(60L, TimeUnit.SECONDS).dispatcher(httpClientDispatcher.get()).addInterceptor((Interceptor)OkHttpInterceptorImpl.instance).sslSocketFactory(HttpSsl.getSSLSocketFactory(), HttpSsl.getX509TrustManager()).hostnameVerifier((HostnameVerifier)HttpSsl.defaultHostnameVerifier).build();
    private OkHttpClient _client;

    public OkHttpUtilsImpl(String url) {
        this(url, null);
    }

    public OkHttpUtilsImpl(String url, OkHttpClient client) {
        super(url);
        this._client = client == null ? httpClient : client;
    }

    @Override
    protected HttpResponse execDo(String _method, final CompletableFuture<HttpResponse> future) throws IOException {
        String method = _method.toUpperCase();
        Request.Builder _builder = new Request.Builder().url(this._url);
        if (this._timeout != null) {
            _builder.tag(HttpTimeout.class, (Object)this._timeout);
        }
        if (this._headers != null) {
            this._headers.forEach(kv -> {
                for (String val : kv.getValues()) {
                    _builder.addHeader(kv.getKey(), val);
                }
            });
        }
        if (this._cookies != null) {
            _builder.header("Cookie", this.getRequestCookieString((MultiMap<String>)this._cookies));
        }
        StreamBody _body = null;
        if (this._bodyRaw != null) {
            _body = new StreamBody(this._bodyRaw);
        } else if (this._multipart) {
            MultipartBody.Builder _part_builer = new MultipartBody.Builder().setType(MultipartBody.FORM);
            if (this._files != null) {
                for (KeyValues kv2 : this._files) {
                    for (Object val : kv2.getValues()) {
                        _part_builer.addFormDataPart(kv2.getKey(), ((HttpUploadFile)val).fileName, (RequestBody)new StreamBody(((HttpUploadFile)val).fileStream));
                    }
                }
            }
            if (this._params != null) {
                for (KeyValues kv2 : this._params) {
                    for (Object val : kv2.getValues()) {
                        _part_builer.addFormDataPart(kv2.getKey(), (String)val);
                    }
                }
            }
            try {
                _body = _part_builer.build();
            }
            catch (IllegalStateException illegalStateException) {}
        } else if (this._params != null) {
            String _form_builer = new FormBody.Builder(this._charset);
            for (KeyValues kv3 : this._params) {
                for (String val : kv3.getValues()) {
                    _form_builer.add(kv3.getKey(), val);
                }
            }
            _body = _form_builer.build();
        }
        switch (method.toUpperCase()) {
            case "POST": {
                _builder.method("POST", (RequestBody)_body);
                break;
            }
            case "PUT": {
                _builder.method("PUT", (RequestBody)_body);
                break;
            }
            case "DELETE": {
                _builder.method("DELETE", (RequestBody)_body);
                break;
            }
            case "PATCH": {
                _builder.method("PATCH", (RequestBody)_body);
                break;
            }
            case "GET": {
                _builder.method("GET", null);
                break;
            }
            case "HEAD": {
                _builder.method("HEAD", null);
                break;
            }
            case "OPTIONS": {
                _builder.method("OPTIONS", null);
                break;
            }
            case "TRACE": {
                _builder.method("TRACE", null);
                break;
            }
            default: {
                throw new IllegalArgumentException("This method is not supported");
            }
        }
        final OkHttpUtilsImpl self = this;
        if (future == null) {
            Call call = this._client.newCall(_builder.build());
            return new OkHttpResponseImpl(this, call.execute());
        }
        this._client.newCall(_builder.build()).enqueue(new Callback(){

            public void onFailure(Call call, IOException e) {
                future.completeExceptionally(e);
                call.cancel();
            }

            public void onResponse(Call call, Response response) throws IOException {
                future.complete(new OkHttpResponseImpl(self, response));
            }
        });
        return null;
    }

    public static class StreamBody
    extends RequestBody {
        private MediaType _contentType = null;
        private HttpStream _httpStream = null;

        public StreamBody(HttpStream stream) {
            if (stream.getContentType() != null) {
                this._contentType = MediaType.parse((String)stream.getContentType());
            }
            this._httpStream = stream;
        }

        public MediaType contentType() {
            return this._contentType;
        }

        public long contentLength() throws IOException {
            return this._httpStream.getContentLength();
        }

        public void writeTo(BufferedSink sink) throws IOException {
            Source source = null;
            try {
                source = Okio.source((InputStream)this._httpStream.getContent());
                sink.writeAll(source);
            }
            catch (Throwable throwable) {
                Util.closeQuietly(source);
                throw throwable;
            }
            Util.closeQuietly((Closeable)source);
        }
    }
}

