/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.net.http.impl.jdk;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Type;
import java.net.HttpURLConnection;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import org.noear.solon.Utils;
import org.noear.solon.core.util.IoUtil;
import org.noear.solon.core.util.MultiMap;
import org.noear.solon.exception.SolonException;
import org.noear.solon.net.http.HttpResponse;
import org.noear.solon.net.http.impl.jdk.JdkHttpUtilsImpl;
import org.noear.solon.net.http.impl.jdk.JdkInputStreamWrapper;

public class JdkHttpResponseImpl
implements HttpResponse {
    private final JdkHttpUtilsImpl utils;
    private final HttpURLConnection http;
    private final int statusCode;
    private final MultiMap<String> headers;
    private final InputStream body;

    public JdkHttpResponseImpl(JdkHttpUtilsImpl utils, HttpURLConnection http) throws IOException {
        this.utils = utils;
        this.http = http;
        this.statusCode = http.getResponseCode();
        this.headers = new MultiMap();
        for (Map.Entry<String, List<String>> kv : http.getHeaderFields().entrySet()) {
            if (kv.getKey() == null) continue;
            this.headers.holder(kv.getKey()).setValues(kv.getValue());
        }
        InputStream inputStream = this.statusCode < 400 ? http.getInputStream() : http.getErrorStream();
        String gzip = http.getHeaderField("Content-Encoding");
        if (Utils.isNotEmpty((String)gzip) && gzip.contains("gzip")) {
            inputStream = new GZIPInputStream(inputStream);
        }
        this.body = new JdkInputStreamWrapper(http, inputStream);
    }

    @Override
    public Collection<String> headerNames() {
        return this.headers.keySet();
    }

    @Override
    public String header(String name) {
        List<String> values = this.headers(name);
        if (values == null || values.isEmpty()) {
            return null;
        }
        return values.get(0);
    }

    @Override
    public List<String> headers(String name) {
        return this.headers.getAll(name);
    }

    @Override
    public Long contentLength() {
        return this.http.getContentLengthLong();
    }

    @Override
    public String contentType() {
        return this.http.getContentType();
    }

    @Override
    public Charset contentEncoding() {
        String tmp = this.http.getContentEncoding();
        return tmp == null ? null : Charset.forName(tmp);
    }

    @Override
    public List<String> cookies() {
        return this.headers("Set-Cookie");
    }

    @Override
    public int code() {
        return this.statusCode;
    }

    @Override
    public InputStream body() {
        return this.body;
    }

    @Override
    public byte[] bodyAsBytes() throws IOException {
        try {
            byte[] byArray = IoUtil.transferToBytes((InputStream)this.body());
            return byArray;
        }
        finally {
            this.body().close();
        }
    }

    @Override
    public String bodyAsString() throws IOException {
        try {
            String string = IoUtil.transferToString((InputStream)this.body());
            return string;
        }
        finally {
            this.body().close();
        }
    }

    @Override
    public <T> T bodyAsBean(Type type) throws IOException {
        if (String.class == this.utils.serializer().dataType()) {
            return (T)this.utils.serializer().deserialize((Object)this.bodyAsString(), type);
        }
        if (byte[].class == this.utils.serializer().dataType()) {
            return (T)this.utils.serializer().deserialize((Object)this.bodyAsBytes(), type);
        }
        throw new SolonException("Invalid serializer type!");
    }

    @Override
    public void close() throws IOException {
        this.body().close();
    }
}

